
//--------------------ݒ--------------------------------------------------

#include "std.mi"
#include "attribs.m"

/*******************************************************************************
//      ֐錾
*******************************************************************************/

Function fn_UpdateSeek(int x, int y);
Function fn_FrameSet(int f);

/*******************************************************************************
//      O[o֐錾
*******************************************************************************/

Global Group   grpSeek;
Global Map     mapSeekMap;
Global Map     mapSeekMap2;
Global Layer   lyrSeek;
Global Timer   tmrSongPlayingTimer;
Global Boolean blnSeekChanging;

/*******************************************************************************
//      #System.onScriptLoaded()
//      XNvgNɎs
//      ݒ
*******************************************************************************/

System.onScriptLoaded(){

	initAttribs();

        // IuWFNgݒ
        grpSeek     = getScriptGroup();
        lyrSeek     = grpSeek.findObject("seek");

        // }bvݒ
        mapSeekMap = new Map;
        mapSeekMap.loadMap("player.map.click");
        mapSeekMap2 = new Map;
        mapSeekMap2.loadMap("player.map.drag");

        // ^C}[ݒ
        tmrSongPlayingTimer = new Timer;
        tmrSongPlayingTimer.setDelay(1000);

        // ÑXC_[|WVɏ]V[No[̕\XV
        if (getStatus() != 0) {
                tmrSongPlayingTimer.start();
                fn_FrameSet(255 * System.getPosition() / System.getPlayItemLength());
        } else {
                fn_FrameSet(0);
        }

}


/*******************************************************************************
//      #System.onScriptUnLoaded()
//      XNvgIɎs
*******************************************************************************/

System.onScriptUnloading() {
        delete mapSeekMap;
        delete mapSeekMap2;
        delete tmrSongPlayingTimer;
}


/*******************************************************************************
//      #System.onPlay()
//      FĐJnɌĂяo
//      @\FtmeSongPlayingTimer̃X^[g
*******************************************************************************/

System.onPlay() {
        tmrSongPlayingTimer.start();
}


/*******************************************************************************
//      #System.onStop()
//      F~ɌĂяo
//      @\FtmeSongPlayingTimer̒~V[N\0ɕύX
*******************************************************************************/

System.onStop() {
        tmrSongPlayingTimer.stop();
        fn_FrameSet(0);
}


/*******************************************************************************
//      #tmrSongPlayingTimer.onTimer()
//      FtmrSongPlayingTimer̃X^[g1bゲƂɌĂяo
//      @\FĐ̃V[N\XV
*******************************************************************************/

tmrSongPlayingTimer.onTimer() {
        fn_FrameSet(255 * System.getPosition() / System.getPlayItemLength());
}


/*******************************************************************************
//      #lyrSeek.onLeftButtonDown(
//        int x         //X
//        int y         //Y
//      )
//      FV[NIuWFNg
//            }EX̍{^ꂽɌĂяo
//      @\F mapSeekMap ͈͓̔Ȃ΁AtO(blnSeekChanging)ONɂāA
//            V[N̕ύXJn
*******************************************************************************/

lyrSeek.onLeftButtonDown(int x, int y) {
        if (!mapSeekMap.inRegion(x - lyrSeek.getLeft(), y - lyrSeek.getTop())) return;
        if (getStatus() == 0) return;


	seek_position_out_attrib.setData("0");
	tmrSongPlayingTimer.stop();
	blnSeekChanging = 1;
	fn_UpdateSeek(x, y);
}


/*******************************************************************************
//      #lyrSeek.onLeftButtonUp(
//        int x         //X
//        int y         //Y
//      )
//      FV[NIuWFNg
//            }EX̍{^ꂽɌĂяo
//      @\FtO(blnSeekChanging)ONȂAV[NύX
*******************************************************************************/

lyrSeek.onLeftButtonUp(int x, int y) {
        if (!blnSeekChanging) return;
        tmrSongPlayingTimer.start();
	blnSeekChanging = 0;

	if (x > 0 && y > 0 && x < 400 && y < 400) { // CEChE͈͓Ȃ

		if (x >= (lyrSeek.getLeft() + lyrSeek.getWidth())) {
		  x = (lyrSeek.getLeft() + lyrSeek.getWidth()) - 1 ;
		}

	  fn_UpdateSeek(x, y);
        } else {

	  seek_position_out_attrib.setData("2");
	  seek_position_attrib.setData("0");
	}
}


/*******************************************************************************
//      #lyrSeek.onMouseMove(
//        int x         //X
//        int y         //Y
//      )
//      FV[NIuWFNgŃ}EXɌĂяo
//      @\FtO(blnSeekChanging)ONȂAV[N̂̕ύX
*******************************************************************************/

lyrSeek.onMouseMove(int x, int y) {
        if (!blnSeekChanging) return;

		if (x < 0 || y < 0 || x > 400 || y > 400) { // CEChE͈͊OȂ
		  seek_position_out_attrib.setData("1");
		} else {
		  seek_position_out_attrib.setData("0");
		}

                if (x >= (lyrSeek.getLeft() + lyrSeek.getWidth())) {
                  x = (lyrSeek.getLeft() + lyrSeek.getWidth()) - 1 ;
                }

	fn_UpdateSeek(x, y);
}


/*--------------֐------------------------------------------------------*/

/*******************************************************************************
//      #fn_FrameSet(
//        int    Value        //V[N̒l
//      )
//      @\FV[N̒lɏ] lyrSeek ̕\ύX
*******************************************************************************/

fn_FrameSet(int Value){
        Region r = new Region;
        r.loadFromMap(mapSeekMap2, Value, 1);
        lyrSeek.setRegion(r);
        delete r;
}


/*******************************************************************************
//      #fn_UpdateSeek(
//        int    x        //}EẌʒu(X)
//        int    y        //}EẌʒu(Y)
//      )
//      @\F}EXʒu mapSeekMap2 V[Nl擾
//            blnSeekChanging OFFȂV[NlύX
*******************************************************************************/

fn_UpdateSeek(int x, int y) {
        int newValue = mapSeekMap2.getValue(x - lyrSeek.getLeft(), 1);

	if (System.getPlayItemLength() >= 0) {
	  int s = (newValue * System.getPlayItemLength()) / 255;
		if (!blnSeekChanging) {
		  System.seekTo(s);
		}
	  fn_FrameSet(255 * s / System.getPlayItemLength());
	  seek_position_attrib.setData(System.integerToTime(s));

	}
}

