#include "std.mi"

Function UpdateVis(Int Frame);


Global Group		grpMain;
Global Group		grpVuMaterL;
Global Group		grpVuMaterR;
Global Group		grpVuMaterC;
Global Timer		VisTimer;
Global Double		LevelL, LevelR, Level, OneFrameL, OneFrameR, OneFrame;
Global Int		LastFrameL, LastFrameR, LastFrame;
Global AnimatedLayer	aniVuL;
Global AnimatedLayer	aniVuR;
Global AnimatedLayer	aniVuC;

System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpVuMaterL	= grpMain.findObject("AniVuL.Group");
	grpVuMaterR	= grpMain.findObject("AniVuR.Group");
	grpVuMaterC	= grpMain.findObject("AniVuC.Group");
	aniVuL		= grpVuMaterL.findObject("AniVuL");
	aniVuR		= grpVuMaterR.findObject("AniVuR");
	aniVuC		= grpVuMaterC.findObject("AniVuC");

	VisTimer = new Timer;
	VisTimer.setDelay(50);
	VisTimer.start();

	aniVuL.setSpeed(50);
	aniVuR.setSpeed(50);
	aniVuC.setSpeed(50);

	OneFrameR = 255/(aniVuL.getLength());
	OneFrameL = 255/(aniVuR.getLength());
	OneFrame = 255/(aniVuC.getLength());
}

System.onScriptUnloading() {
	
	VisTimer.stop();
    	delete VisTimer;
}


VisTimer.onTimer() {

	LevelL = (System.getLeftVuMeter());
	LevelR = (System.getRightVuMeter());
	Level = ((System.getLeftVuMeter() + System.getRightVuMeter())/2);

	UpdateVis(LevelL/OneFrameL);
	UpdateVis(LevelR/OneFrameR);
	UpdateVis(Level/OneFrame);
}

UpdateVis(Int Frame){

	aniVuL.setStartFrame(LastFrameR);
     	aniVuL.setEndFrame(Frame);
     	aniVuL.play();
	aniVuR.setStartFrame(LastFrameL);
     	aniVuR.setEndFrame(Frame);
     	aniVuR.play();
	aniVuC.setStartFrame(LastFrame);
     	aniVuC.setEndFrame(Frame);
     	aniVuC.play();
     	LastFrameL = Frame;
     	LastFrameR = Frame;
     	LastFrame = Frame;
}

