#include "std.mi"

Function fn_FrameSet(int f);
Function fn_ReSizeLayer(Layer l, int TargetX, int TargetY, Float Speed, int TargetA);

Global Group	grpMain;
Global Map	mapSeekMap2;
Global Layer	lyrSeek;
Global Timer	tmrSongPlayingTimer;
Global Boolean	blnSeekChanging;
Global Group	grpSingInfo;
Global Group	grpButton;
Global Button	play;
Global Button	pause;

System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
        grpSingInfo	= grpMain.findObject("SingInfo.Group");
        grpButton	= grpSingInfo.findObject("PlayButton.Group");
        lyrSeek 	= grpButton.findObject("Play2");
        play		= grpButton.findObject("play");
        pause		= grpButton.findObject("pause");

        mapSeekMap2= new Map;
        mapSeekMap2.loadMap("Play2Map");

        tmrSongPlayingTimer = new Timer;
        tmrSongPlayingTimer.setDelay(1000);


        if (getplayitemstring() != "") {
                tmrSongPlayingTimer.start();
                fn_FrameSet(255 * System.getPosition() / System.getPlayItemLength());
        } else {
                fn_FrameSet(0);
        }
}


System.onScriptUnloading() {

        delete mapSeekMap2;
        delete tmrSongPlayingTimer;
}

play.onLeftButtonUp(int x, int y){

		fn_ReSizeLayer(lyrSeek, 0, 0, 0.1, 255);
}
pause.onLeftButtonUp(int x, int y){

		fn_ReSizeLayer(lyrSeek, 0, 0, 0.1, 255);
}
play.onLeftButtonDown(int x, int y){

		fn_ReSizeLayer(lyrSeek, 1, 1, 0.1, 255);
}
pause.onLeftButtonDown(int x, int y){

		fn_ReSizeLayer(lyrSeek, 1, 1, 0.1, 255);
}

System.onPlay(){

        tmrSongPlayingTimer.start();
}

System.onStop(){

	tmrSongPlayingTimer.stop();
        fn_FrameSet(0);
}

tmrSongPlayingTimer.onTimer(){

        fn_FrameSet(255 * System.getPosition() / System.getPlayItemLength());
}

fn_FrameSet(int Value){

        Region r = new Region;
        r.loadFromMap(mapSeekMap2, Value, 1);
        lyrSeek.setRegion(r);
        delete r;
}

fn_ReSizeLayer(Layer l, int TargetX, int TargetY, Float Speed, int TargetA){

        l.setTargetX(TargetX);
        l.setTargetY(TargetY);
        l.setTargetSpeed(Speed);
        l.setTargetA(TargetA);
        l.gotoTarget();
}