#include "std.mi"

Function Fn_FadeText(Text T,int TargetA,Float Speed);

Global Group	grpMain;
Global Group	grpSongTitle;
Global Text	titleT;
Global Text	artistT;
//Global Text	albumT;
Global string	pre_title;
Global string	pre_artist;
//Global string	pre_album;
Global Timer	tmrFade;
Global int	intFade;	//(0:Title 1:Artist 2:Album)

System.onScriptLoaded() {

	grpMain = getScriptGroup();
	grpSongTitle = grpMain.findObject("SingInfo.Group");
	titleT = grpSongTitle.findObject("songTitle");
	artistT = grpSongTitle.findObject("songArtist");
//	albumT = grpSongTitle.findObject("songAlbum");

	tmrFade = new Timer;
	tmrFade.setDelay(1600);
	tmrFade.start();
}

System.onScriptUnloading() {

	tmrFade.Stop();
	delete tmrFade;
}

tmrFade.onTimer() {

	tmrFade.Stop();

	pre_title 	= System.getPlayItemMetaDataString("title");
	pre_artist 	= System.getPlayItemMetaDataString("artist");
//	pre_album 	= System.getPlayItemMetaDataString("album");

	titleT.setText(pre_title);
	artistT.setText(pre_artist);
//	albumT.setText(pre_album);

	int intTitleW	= titleT.getTextWidth();
	int intArtistW = artistT.getTextWidth();

	string notitle = "? ? ?";
	string noartist = "? ? ?";

	if(intTitleW <= 4) titleT.setText(notitle);
	if(intArtistW <= 4) artistT.setText(noartist);

	//(0:Title 1:Artist 2:Album)
	if (intFade == 0){
		Fn_FadeText(titleT,255,1);
		Fn_FadeText(artistT,0,1);
		intFade = 1;
	}
	else if(intFade == 1){
		Fn_FadeText(titleT,0,1);
		Fn_FadeText(artistT,255,1);
		intFade = 0;
	}

	tmrFade.setDelay(8000);
	tmrFade.start();
}

System.onTitlechange(String newTitle) {

	tmrFade.setDelay(50);
	tmrFade.start();
	intFade = 0;	//(0:Title 1:Artist 2:Album)
}

Fn_FadeText(Text T,int TargetA,Float Speed){

	T.setTargetA(TargetA);
	T.setTargetSpeed(Speed);
	T.gotoTarget();
}