#include "std.mi"

Function UpdateVis(Int Frame);


Global Group		grpMain;
Global Group		grpVuMater;
Global Timer		VisTimer;
Global Double		Level, OneFrame;
Global Int		LastFrame;
Global AnimatedLayer	aniVu;

System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpVuMater	= grpMain.findObject("AniVu.Group");
	aniVu		= grpVuMater.findObject("AniVu");

	VisTimer = new Timer;
	VisTimer.setDelay(50);
	VisTimer.start();

	aniVu.setSpeed(50);

	OneFrame = 255/(aniVu.getLength());
}

System.onScriptUnloading() {
	
	VisTimer.stop();
    	delete VisTimer;
}


VisTimer.onTimer() {

	Level = ((System.getLeftVuMeter() + System.getRightVuMeter())/2);

	UpdateVis(Level/OneFrame);
}

UpdateVis(Int Frame){

	aniVu.setStartFrame(LastFrame);
     	aniVu.setEndFrame(Frame);
     	aniVu.play();
     	LastFrame = Frame;
}

