#include "std.mi"

Function UpdateVis(Int Frame);


Global Group		grpMain;
Global Group		grpVuMaterL;
Global Group		grpVuMaterR;
Global Group		grpVuMaterM;
Global Timer		VisTimer;
Global Double		LevelL, LevelR, Level, OneFrameL, OneFrameR, OneFrame;
Global Int		LastFrameL, LastFrameR, LastFrame;
Global AnimatedLayer	aniVuR;
Global AnimatedLayer	aniVuL;
Global AnimatedLayer	aniVuM;

System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpVuMaterL	= grpMain.findObject("AniVuL.Group");
	grpVuMaterR	= grpMain.findObject("AniVuR.Group");
	grpVuMaterM	= grpMain.findObject("AniVuM.Group");
	aniVuR		= grpVuMaterR.findObject("AniVuR");
	aniVuL		= grpVuMaterL.findObject("AniVuL");
	aniVuM		= grpVuMaterL.findObject("AniVuM");

	VisTimer = new Timer;
	VisTimer.setDelay(50);
	VisTimer.start();

	aniVuR.setSpeed(50);
	aniVuL.setSpeed(50);
	aniVuM.setSpeed(50);

	OneFrameR = 255/(aniVuR.getLength());
	OneFrameL = 255/(aniVuL.getLength());
	OneFrame = 255/(aniVuM.getLength());
}

System.onScriptUnloading() {
	
	VisTimer.stop();
    	delete VisTimer;
}


VisTimer.onTimer() {

	LevelL = (System.getLeftVuMeter());
	LevelR = (System.getRightVuMeter());
	Level = ((System.getLeftVuMeter() + System.getRightVuMeter())/2);
	UpdateVis(LevelL/OneFrameL);
	UpdateVis(LevelR/OneFrameR);
	UpdateVis(Level/OneFrame);
}


UpdateVis(Int Frame){

	aniVuR.setStartFrame(LastFrameR);
     	aniVuR.setEndFrame(Frame);
     	aniVuR.play();
	aniVuL.setStartFrame(LastFrameL);
     	aniVuL.setEndFrame(Frame);
     	aniVuL.play();
	aniVuM.setStartFrame(LastFrame);
     	aniVuM.setEndFrame(Frame);
     	aniVuM.play();
     	LastFrameL = Frame;
     	LastFrameR = Frame;
     	LastFrame = Frame;
}

