#include "std.mi"

Global Group		grpMain;
Global Group		grpEtcBtn;
Global Group		grpSeeker;
Global Group		grpAlbmArt;
Global Button		btnEtc;
Global ToggleButton	btnAlbArt;
Global int 		intEtcBtnState;
Global int 		intAlbArtState;

System.onScriptLoaded() {

	grpMain 	= getScriptGroup();
	grpEtcBtn	= grpMain.findObject("EtcButtons.Group");
	grpSeeker	= grpMain.findObject("seeker.Group");
	grpAlbmArt	= grpMain.findObject("AlbumArt.Group");
	btnEtc		= grpMain.findObject("etc");
	btnAlbArt	= grpMain.findObject("BtnAlubumArt");
	intEtcBtnState	= System.getPrivateInt("Yui", "EtcBtnState", 0);
	intAlbArtState	= System.getPrivateInt("Yui", "AlbArtState", 0);


	if (intEtcBtnState == 0){

		grpEtcBtn.Hide();
		grpSeeker.Show();
	}
	else if(intEtcBtnState == 1){

		grpEtcBtn.Show();
		grpSeeker.Hide();
	}
	if (intAlbArtState == 0){

		grpAlbmArt.Show();
	}
	else if(intAlbArtState == 1){

		grpAlbmArt.Hide();
		btnAlbArt.leftclick();
	}
}

System.onScriptUnloading() {

	System.setPrivateInt("Yui", "EtcBtnState", intEtcBtnState);
	System.setPrivateInt("Yui", "AlbArtState", intAlbArtState);
}

btnEtc.onLeftButtonUp(int x, int y) {
	
	if (intEtcBtnState == 1){

		grpEtcBtn.Hide();
		grpSeeker.Show();
		intEtcBtnState = 0;
	}
	else if(intEtcBtnState == 0){

		grpEtcBtn.Show();
		grpSeeker.Hide();
		intEtcBtnState = 1;
	}
}

btnAlbArt.onToggle(boolean on) {

	intAlbArtState = stringtointeger(btnAlbArt.getXmlParam("cfgval"));

	if(intAlbArtState == 0){

		grpAlbmArt.Show();
	}
	else if(intAlbArtState == 1){
	
		grpAlbmArt.Hide();
	}
}