#include "std.mi"

Function Fn_ReSizeButton(Button b, int TargetX, int TargetY, Float Speed, int TargetA);

Global Group		grpMain;
Global Group		grpSonginfo;
Global Group		grpAlbmArt;
Global ToggleButton	btnAlbArt;
Global int 		intAlbArtState;
Global Button 		btnPrev;
Global Button 		btnNext;
Global Button 		btnStop;
Global Group		BNSButtons;

System.onScriptLoaded() {

	grpMain 	= getScriptGroup();
	grpSonginfo	= grpMain.findObject("SingInfo.Group");
	grpAlbmArt	= grpMain.findObject("AlbumArt.Group");
	btnAlbArt	= grpSonginfo.findObject("BtnAlubumArt");
	intAlbArtState	= System.getPrivateInt("Scarlet", "AlbArtState", 0);
	BNSButtons	= grpMain.findObject("BNSButtons.Group");
	btnPrev		= BNSButtons.findObject("Previous");
	btnNext		= BNSButtons.findObject("Next");
	btnStop		= BNSButtons.findObject("Stop");

	if (intAlbArtState == 0){

		grpAlbmArt.Show();
		Fn_ReSizeButton(btnPrev, 132, 9, 1.0, 255);
		Fn_ReSizeButton(btnNext, 185, 0, 1.0, 255);
		Fn_ReSizeButton(btnStop, 125, 52, 1.0, 255);
	}
	else if(intAlbArtState == 1){

		grpAlbmArt.Hide();
		btnAlbArt.leftclick();
		Fn_ReSizeButton(btnPrev, 0, 43, 1.0, 255);
		Fn_ReSizeButton(btnNext, 84, 43, 1.0, 255);
		Fn_ReSizeButton(btnStop, 42, 43, 1.0, 255);
	}
}

System.onScriptUnloading() {

	System.setPrivateInt("Scarlet", "AlbArtState", intAlbArtState);
}

btnAlbArt.onToggle(boolean on) {

	intAlbArtState = stringtointeger(btnAlbArt.getXmlParam("cfgval"));

	if(intAlbArtState == 0){

		grpAlbmArt.Show();
		Fn_ReSizeButton(btnPrev, 132, 9, 1.0, 255);
		Fn_ReSizeButton(btnNext, 185, 0, 1.0, 255);
		Fn_ReSizeButton(btnStop, 125, 52, 1.0, 255);
	}
	else if(intAlbArtState == 1){
	
		grpAlbmArt.Hide();
		Fn_ReSizeButton(btnPrev, 0, 43, 1.0, 255);
		Fn_ReSizeButton(btnNext, 84, 43, 1.0, 255);
		Fn_ReSizeButton(btnStop, 42, 43, 1.0, 255);
	}
}

Fn_ReSizeButton(Button b, int TargetX, int TargetY, Float Speed, int TargetA){

        b.setTargetX(TargetX);
        b.setTargetY(TargetY);
        b.setTargetSpeed(Speed);
        b.setTargetA(TargetA);
        b.gotoTarget();
}