#include "std.mi"

Function UpdateVis(Int Frame);


Global Group		grpMain;
Global Group		grpVuMater;
Global Group		grpAni_Efect;
Global Group		grpPlayButton;
Global Timer		VisTimer;
Global Double		LevelL, LevelR, Level, OneFrameL, OneFrameR, OneFrame;
Global Int		LastFrameL, LastFrameR, LastFrame;
Global AnimatedLayer	aniVu;
Global AnimatedLayer	aniEfect;
Global AnimatedLayer	aniPause;
Global int		intCharaNmber;	//( 0, 1, 2, 3, 4,5)
Global Button		btnPause;

System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpVuMater	= grpMain.findObject("AniVu.Group");
	grpAni_Efect	= grpMain.findObject("Ani_RedEfect.Group");
	grpPlayButton	= grpMain.findObject("PlayButton.Group");
	aniVu		= grpVuMater.findObject("AniVu");
	aniEfect	= grpAni_Efect.findObject("Ani_RedEfect");
	aniPause	= grpPlayButton.findObject("Ani_Pause");
	btnPause	= grpPlayButton.findObject("Pause");

	VisTimer = new Timer;
	VisTimer.setDelay(50);
	VisTimer.start();

	aniVu.setSpeed(50);
	aniEfect.setSpeed(50);
	aniPause.setSpeed(50);
	OneFrameR = 255/(aniVu.getLength());
	OneFrameL = 255/(aniEfect.getLength());
	OneFrame = 255/(aniPause.getLength());
}

System.onScriptUnloading() {
	
	VisTimer.stop();
    	delete VisTimer;
}


VisTimer.onTimer() {

	intCharaNmber	= System.getPrivateInt("Scarlet", "CharaNmber", 0);

	if(intCharaNmber == 0) {
		aniVu = grpVuMater.findObject("AniVu");
	}
	else if(intCharaNmber == 1) {
		aniVu = grpVuMater.findObject("AniVu2");
	}
	else if(intCharaNmber == 2) {
		aniVu = grpVuMater.findObject("AniVu3");
	}
	else if(intCharaNmber == 3) {
		aniVu = grpVuMater.findObject("AniVu4");
	}
	else if(intCharaNmber == 4) {
		aniVu = grpVuMater.findObject("AniVu5");
	}
	else if(intCharaNmber == 5) {
		aniVu = grpVuMater.findObject("AniVu6");
	}

	LevelL = (System.getLeftVuMeter());
	LevelR = (System.getRightVuMeter());
	Level = ((System.getLeftVuMeter() + System.getRightVuMeter())/2);
	UpdateVis(LevelL/OneFrameL);
	UpdateVis(LevelR/OneFrameR);
	UpdateVis(Level/OneFrame);
}

btnPause.onEnterArea() {

	aniPause.hide();
}
btnPause.onLeaveArea() {

	//vCԊmF STATUS_PAUSED (-1), STATUS_STOPPED (0), STATUS_PLAYING (1)
	if(getStatus() == 1) {
       		aniPause.Show();
	}
	else if(getStatus() == 0) {
		aniPause.hide();
	}
	else if(getStatus() == -1) {
		aniPause.hide();
	}
}
system.onplay() {

       	aniPause.Show();
}
system.onstop() {

	aniPause.hide();
}

system.onpause() {

	aniPause.hide();
}

system.onResume() {

       	aniPause.Show();
}

UpdateVis(Int Frame){

	aniVu.setStartFrame(LastFrameR);
     	aniVu.setEndFrame(Frame);
     	aniVu.play();
	aniEfect.setStartFrame(LastFrameL);
     	aniEfect.setEndFrame(Frame);
     	aniEfect.play();
	aniPause.setStartFrame(LastFrame);
     	aniPause.setEndFrame(Frame);
     	aniPause.play();
     	LastFrameL = Frame;
     	LastFrameR = Frame;
     	LastFrame = Frame;
}

