//--------------------初期設定--------------------------------------------------

#include "std.mi"

/*******************************************************************************
//      自作関数宣言
*******************************************************************************/

/*******************************************************************************
//      グローバル関数宣言
*******************************************************************************/

Global Layout        Main;
Global Group         grpToggle;
Global ToggleButton  tglMedley;
Global ToggleButton  tglRepeat;

Global Group         grpPositionSlider;
Global Slider        sldMedleyStart;
Global Slider        sldMedleyEnd;
Global Text          txtStartPos;
Global Text          txtEndPos;

Global Timer         tmrSongPlayTimer;
Global Timer         tmrFadeingTimer;
Global Timer         tmrHookTimer;

Global Int           intDefVolume;      //元のボリューム
Global Int           intAddSubVolume;   //ボリュームの加減値
Global Int           intSongChangeFlg;  //メドレーの曲変更段階のフラグ
Global Int           intStartPos;       //メドレーのスタート位置(％)
Global Int           intEndPos;         //メドレーの終了秒
Global Int           intRep;            //メドレー前のリピート状態
Global Boolean       blnMedleyMode;     //メドレー機能の状態
Global Boolean       blnNextChk;        //メドレー中の Next 処理のチェック
Global Boolean       blnPause;

/*******************************************************************************
//      #System.onScriptLoaded()
//      スクリプト起動時に実行される｡
//      初期設定
*******************************************************************************/

System.onScriptLoaded() {

        // オブジェクト設定
        main              = getContainer("main").getLayout("normal");
        grpToggle         = main.findObject("Player.toggle.Group");
        tglMedley         = grpToggle.findObject("medley.s");
        tglRepeat         = grpToggle.findObject("Repeat.s");

        grpPositionSlider = getScriptGroup();
        sldMedleyStart    = grpPositionSlider.findObject("Start");
        sldMedleyEnd      = grpPositionSlider.findObject("End");
        txtStartPos       = grpPositionSlider.getObject("StartText");
        txtEndPos         = grpPositionSlider.getObject("EndText");


        //タイマー設定
        tmrSongPlayTimer = new Timer;
        tmrFadeingTimer = new Timer;
        tmrFadeingTimer.setDelay(50);
        tmrHookTimer = new Timer;
        tmrHookTimer.setDelay(1000);

        // 設定の読み込み
        intStartPos = (System.getPrivateInt("Trans_General_Setting", "MedleyStart", 50 ));   //メドレー開始位置
        intEndPos   = (System.getPrivateInt("Trans_General_Setting", "MedleyEnd", 30000));        //メドレー再生秒数

        sldMedleyStart.setPosition(intStartPos);   //メドレー開始位置
        sldMedleyEnd.setPosition((intEndPos - 6000) / 1000);    //メドレー再生秒数

        intDefVolume    = System.getVolume();
        intAddSubVolume = 2;

        tmrSongPlayTimer.setDelay(intEndPos);

}


/*-----------------通常動作部分-----------------------------------------------*/

/*******************************************************************************
//      #System.onScriptUnLoaded()
//      スクリプト終了時に実行される｡
*******************************************************************************/

System.onScriptUnloading() { //スクリプト終了時に呼び出される関数

        System.setPrivateInt("Trans_General_Setting", "MedleyStart", sldMedleyStart.getPosition());   //メドレー開始位置の保存
        System.setPrivateInt("Trans_General_Setting", "MedleyEnd", intEndPos);       //メドレー再生秒数の保存

        delete tmrHookTimer;
        delete tmrFadeingTimer;
        delete tmrSongPlayTimer;
}


/*******************************************************************************
//      #tmrFadeingTimer.onTimer()
//      条件：tmrFadeingTimerのスタート後30msごとに呼び出される｡
//      機能：音量のフェード
*******************************************************************************/

tmrFadeingTimer.onTimer() {

        if (intSongChangeFlg == 1) {
          System.setVolume(System.getVolume() - intAddSubVolume);

                if (System.getVolume() <= 2) {
                  intSongChangeFlg = 2;
                        if (!blnNextChk) {
                          blnNextChk = 1;
                          System.Next();
                        }
                  //system.SeekTo(intStartPos * (getPlayItemLength() / 100));
                }
        }

        if (intSongChangeFlg == 2) {

                if (getStatus() == -1) {
                  system.SeekTo(intStartPos * (getPlayItemLength() / 100));
                } else {
		  blnPause = 1;
                  system.pause();
                }
                system.SeekTo(intStartPos * (getPlayItemLength() / 100));

                if (System.getPosition() >> (intStartPos * (getPlayItemLength() / 100) - 1000) || System.getPosition() << (intStartPos * (getPlayItemLength() / 100) + 1000)) {
                  tmrSongPlayTimer.Start();
                  intSongChangeFlg = 3;
                  system.play();
                }

        }

        if (intSongChangeFlg == 3) {
          System.setVolume(System.getVolume() + intAddSubVolume);

                if (System.getVolume() >= (intDefVolume - 2)) {
                  System.setVolume(intDefVolume);
                  intSongChangeFlg = 0;
                  blnNextChk = 0;
                  tmrFadeingTimer.Stop();
                }
        }

}

/*******************************************************************************
//      #tmrSongPlayTimer.onTimer()
//      条件：tmrSongPlayTimerのスタート sldMedleyEnd * 1000 秒後に呼び出される｡
//      機能：tmrFadeingTimer のスタート (曲のフェード、次の曲に移動)
*******************************************************************************/

tmrSongPlayTimer.onTimer() {

        if (System.getPlayItemLength() >= 1) { // 通常時の処理
          intSongChangeFlg = 1;
          tmrSongPlayTimer.Stop();
          tmrFadeingTimer.Start();
        } else { // ストリーミングの時、処理に入らない
          intSongChangeFlg = 0;
        }

}


/*******************************************************************************
//      #tmrHookTimer.onTimer()
//      条件：tmrHookTimerのスタート 1000 msごとに呼び出される｡
//      機能：再生位置の確認
*******************************************************************************/

tmrHookTimer.onTimer() {

        if (getPlayItemLength() != 0 && getPosition() >= getPlayItemLength() - 6000) {
          intSongChangeFlg = 1;
          tmrSongPlayTimer.Stop();
          tmrFadeingTimer.Start();
        }
}


/*******************************************************************************
//      #System.onPlay()
//      条件：再生開始時に呼び出される｡
//      機能：tmrSongPlayTimerをスタートさせる｡
*******************************************************************************/

system.onplay() {

        if (blnMedleyMode) {
          intSongChangeFlg = 2;
          system.setVolume(0);
          //system.pause();

          //system.SeekTo(intStartPos * (getPlayItemLength() / 100));

          tmrHookTimer.Start();
          tmrFadeingTimer.Start();
        }
}


/*******************************************************************************
//      #System.onpause()
//      条件：一時停止時に呼び出される｡
//      機能：
*******************************************************************************/

system.onPause() {

	if (!blnPause) {
	  blnPause = 0;
	  return;
	}

	system.onStop();
	System.stop();

}


/*******************************************************************************
//      #System.onStop()
//      条件：停止時に呼び出される｡
//      機能：Timerを停止させる｡
*******************************************************************************/

system.onStop() {

        tmrSongPlayTimer.Stop();
        tmrFadeingTimer.Stop();
        tmrHookTimer.Stop();
        if (blnMedleyMode) System.setVolume(intDefVolume);
        intSongChangeFlg = 0;
        blnNextChk = 0;
}


/*******************************************************************************
//      #System.onVolumeChanged(
//        Int           newvol // 変更後の音量
//      条件：ボリューム変更時に呼び出される｡
//      機能：ボリュームの変更値を記録
*******************************************************************************/

System.onVolumeChanged(int newvol) {

        if (intSongChangeFlg == 0) {
          intDefVolume    = System.getVolume();
          //intAddSubVolume = System.getVolume() / 40;
        }
}


/*******************************************************************************
//      #sldMedleyStart.onSetPosition(
//        Int           newpos // 変更後のポジション(0-255)
//      条件：sldMedleyStart変更時に呼び出される｡
//      機能：変更値に従いメドレー再生の開始位置を変更
*******************************************************************************/

sldMedleyStart.onSetPosition(int newpos) {

        intStartPos = newpos * (95 / 255);
        txtStartPos.setText(integerToString(intStartPos) + " %");

}


/*******************************************************************************
//      #sldMedleyEnd.onSetPosition(
//        Int           newpos // 変更後のポジション(0-255)
//      条件：sldMedleyEnd変更時に呼び出される｡
//      機能：変更値に従いメドレー再生の終了位置を変更
*******************************************************************************/

sldMedleyEnd.onSetPosition(int newpos) {

        // 終了秒を設定
        intEndPos = (newpos * 1000) + 6000;
        // 終了秒数のテキスト表示
        txtEndPos.setText(integerToTime(intEndPos));

	if (blnMedleyMode) tmrSongPlayTimer.setDelay(intEndPos);
}


/*******************************************************************************
//      #tglMedley.onToggle(
//        boolean       on //チェックボックスの状態 1:on 0:off
//      }
//      条件：tglMedleyが変更された時に呼び出される｡
//      機能：メドレー機能の切替
*******************************************************************************/

tglMedley.onToggle(boolean on) {

        if (on) {
          blnMedleyMode = 1;
	  intRep = tglRepeat.getCurCfgVal();

		if (intRep == 0) {
		  tglRepeat.leftClick();
		} else if (intRep == -1) {
		  tglRepeat.leftClick();
		  tglRepeat.leftClick();
		}

                if (getStatus() == 1) {
                  tmrSongPlayTimer.setDelay(intEndPos);
                  tmrSongPlayTimer.start();
                  tmrHookTimer.Start();
                  intSongChangeFlg = 1;
                  tmrFadeingTimer.Start();
                }

        }else{

		if (intRep == 0) {
		  tglRepeat.leftClick();
		  tglRepeat.leftClick();
		} else if (intRep == -1) {
		  tglRepeat.leftClick();
		}

          blnMedleyMode = 0;
          tmrSongPlayTimer.Stop();
          tmrFadeingTimer.Stop();
          tmrHookTimer.Stop();
        }
}


