#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);


Global Group	grpMain;
Global Group	grpInfo;
Global Layer	lyrDrugInfo;
Global int	intPosX;
Global int	intPosY;
Global int	intObjH;
Global int	intObjW;
Global Boolean	blnDrg;


System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpInfo		= grpMain.getObject("SongInfo.Group");
	lyrDrugInfo	= grpInfo.getObject("SongInfo_dummy");
	intPosX		= System.getPrivateInt("RenneI", "PosX", 0);
	intPosY		= System.getPrivateInt("RenneI", "PosY", 0);
	intObjW		= grpInfo.getGuiW();
	intObjH		= grpInfo.getGuiH();

	fn_ReSizeGroup(grpInfo, intPosX, intPosY, intObjW, intObjH, 0.1, 0.1, 255);
}

System.onScriptUnloading(){

	System.setPrivateInt("RenneI", "PosX", intPosX);
	System.setPrivateInt("RenneI", "PosY", intPosY);
}

lyrDrugInfo.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intPosX = grpInfo.getLeft() - x;
	intPosY = grpInfo.getTop() - y;
}

lyrDrugInfo.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	intPosX = grpInfo.getLeft();
	intPosY = grpInfo.getTop();
}

lyrDrugInfo.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpInfo.setXmlParam("x", integerToString(x + intPosX));
	grpInfo.setXmlParam("y", integerToString(y + intPosy));
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}