#include "std.mi"

Global Group	grpMain;
Global Group	grpWindow;
Global Group	grpSongInfo;
Global Text	titleT;
Global Text	artistT;
Global Text	albumT;
Global string	pre_title;
Global string	pre_artist;
Global string	pre_album;
Global Timer	tmrStart;
Global int 	intState;

System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpWindow	= grpMain.findObject("Window.Group");
	grpSongInfo	= grpMain.findObject("SongInfo.Group");
	titleT		= grpWindow.findObject("songTitle");
	artistT		= grpSongInfo.findObject("songArtist");
	albumT		= grpSongInfo.findObject("songAlbum");
	intState	= System.getPrivateInt("Renne", "WindowState", 0);

	tmrStart = new Timer;
	tmrStart.setDelay(100);
	tmrStart.start();
}

System.onScriptUnloading() {

	tmrStart.Stop();
	delete tmrStart;
}

tmrStart.onTimer() {

	tmrStart.Stop();

	pre_title 	= System.getPlayItemMetaDataString("title");
	pre_artist 	= System.getPlayItemMetaDataString("artist");
	pre_album 	= System.getPlayItemMetaDataString("album");

	intState = System.getPrivateInt("Renne", "WindowState", 0);
	if(intState == 2) titleT.setText(pre_title +  " - " + pre_artist);
	else if(intState == 3) titleT.setText(pre_title +  " - " + pre_artist);
	else if(intState == 0) titleT.setText(pre_title);
	else if(intState == 1) titleT.setText(pre_title);

//	titleT.setText(pre_title);
	artistT.setText(pre_artist);
	albumT.setText(pre_album);

	int intTitleW	= titleT.getTextWidth();
	int intArtistW = artistT.getTextWidth();
	int intAlbumW = albumT.getTextWidth();

	string notitle = "? ? ?";
	string noartist = "? ? ?";
	string noalbum = "? ? ?";

	if(intTitleW <= 4) titleT.setText(notitle);
	if(intArtistW <= 4) artistT.setText(noartist);
	if(intAlbumW <= 4) albumT.setText(noalbum);

	tmrStart.setDelay(100);
	tmrStart.start();
}

System.onTitlechange(String newTitle) {

	tmrStart.setDelay(50);
	tmrStart.start();
}