#include "std.mi"

Function fn_UpdateSeek(int x, int y);
Function fn_FrameSet(int f);

Global Group		grpMain;
Global Map		mapSeekMap;
Global Map		mapSeekMap2;
Global Layer		lyrSeek;
Global Group		grpSeeker;
Global Group		grpText01;
Global Text		TimeT;
Global Timer		tmrSongPlayingTimer;
Global Boolean		blnSeekChanging;

System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpSeeker 	= grpMain.findObject("Seeker.Group");
	grpText01 	= grpMain.findObject("Text01.Group");
        lyrSeek 	= grpSeeker.findObject("Seeker");
	TimeT		= grpText01.findObject("SongTime");

        mapSeekMap = new Map;
        mapSeekMap.loadMap("seekmap");

        mapSeekMap2 = new Map;
        mapSeekMap2.loadMap("seekmap2");

        tmrSongPlayingTimer = new Timer;
        tmrSongPlayingTimer.setDelay(1000);

        if (getplayitemstring() != "") {
                tmrSongPlayingTimer.start();
                fn_FrameSet(255 * System.getPosition() / System.getPlayItemLength());
        } else {
                fn_FrameSet(0);
        }
}

System.onScriptUnloading() {

        delete mapSeekMap;
        delete mapSeekMap2;
        delete tmrSongPlayingTimer;
}

System.onPlay() {

        tmrSongPlayingTimer.start();
}

System.onStop() {

	tmrSongPlayingTimer.stop();
        fn_FrameSet(0);
}

tmrSongPlayingTimer.onTimer() {

        fn_FrameSet(255 * System.getPosition() / System.getPlayItemLength());
}

lyrSeek.onLeftButtonDown(int x, int y) {

        if (mapSeekMap.inRegion(x - lyrSeek.getLeft(), y - lyrSeek.getTop())) {
          tmrSongPlayingTimer.stop();
          blnSeekChanging = 1;
          fn_UpdateSeek(x, y);
        }
}

lyrSeek.onLeftButtonUp(int x, int y) {

        tmrSongPlayingTimer.start();
        if (blnSeekChanging) {
                blnSeekChanging = 0;
                fn_UpdateSeek(x, y);
        }
}

lyrSeek.onMouseMove(int x, int y) {

        if (blnSeekChanging) {
                fn_UpdateSeek(x, y);
        }
}

fn_FrameSet(int Value){

        Region r = new Region;
        r.loadFromMap(mapSeekMap2, Value, 1);
        lyrSeek.setRegion(r);
        delete r;
}

fn_UpdateSeek(int x, int y) {

        if (mapSeekMap2.inRegion(x - lyrSeek.getLeft(), y - lyrSeek.getTop())) {
          int newValue = mapSeekMap2.getValue(x - lyrSeek.getLeft(), y - lyrSeek.getTop());
                if (System.getPlayItemLength() >= 0) {
                  int s = (newValue * System.getPlayItemLength()) / 255;
                  int p = (newValue * 100) / 255;                           //***
 			TimeT.setAlternateText("Pos: " + System.integerToTime(s) + " / " + System.integerToTime(System.getPlayItemLength()));
                         if (!blnSeekChanging) {
                          System.seekTo(s);
                         }
                  fn_FrameSet(255 * s / System.getPlayItemLength());
                }
        }
}