#include "std.mi"

Global Group	grpMain;
Global Group	grpSonginfo;
Global Text	txtTime1;
Global Timer	tmrSongTimer;
Global int	intTimeMode;

System.onScriptLoaded(){ 

	grpMain		= getScriptGroup();
	grpSonginfo	= grpMain.findObject("Text01.Group");
	txtTime1	= grpSonginfo.findObject("songTime");
	intTimeMode	= System.getPrivateInt("PMasiro", "Mode", 0);

        tmrSongTimer = new Timer;
        tmrSongTimer.setDelay(50);
        tmrSongTimer.start();

	txtTime1.setTargetA(255);
	txtTime1.setTargetSpeed(0.5);
	txtTime1.gotoTarget();
}


System.onScriptUnloading() {

	System.setPrivateInt("PMasiro", "Mode", intTimeMode);

        tmrSongTimer.Stop();
        delete tmrSongTimer;
}

txtTime1.onLeftButtonUp(int x, int y){

	if(intTimeMode == 0) intTimeMode = 1;
	else if(intTimeMode == 1) intTimeMode = 0;
}

tmrSongTimer.onTimer() {

	tmrSongTimer.Stop();

	if(intTimeMode == 0){
		txtTime1.setText(System.integerToTime(System.getPosition()) + " / " + System.integerToTime(System.getPlayItemLength()));
	}
	else if(intTimeMode == 1){
		txtTime1.setText("- " + System.integerToTime(System.getPlayItemLength() - System.getPosition()) + " / " + System.integerToTime(System.getPlayItemLength()));
	}
        	tmrSongTimer.setDelay(100);
        	tmrSongTimer.start();
}