#include "std.mi"

Function Fn_ReSizeButton(Button b, int TargetX, int TargetY, Float Speed, int TargetA);

Global Group		grpMain;
Global Group		grpSonginfo;
Global Group		grpAlbmArt;
Global Group		grpWindow;
Global ToggleButton	btnAlbArt;
Global int 		intState;

System.onScriptLoaded() {

	grpMain 	= getScriptGroup();
	grpSonginfo	= grpMain.findObject("SongInfo.Group");
	grpAlbmArt	= grpMain.findObject("AlbumArt.Group");
	grpWindow	= grpMain.findObject("Window.Group");
	btnAlbArt	= grpWindow.findObject("BtnAlubumArt");
	intState	= System.getPrivateInt("Rikka", "WindowState", 0);

	if (intState == 0){

		grpAlbmArt.Show();
		grpSonginfo.Show();
	}
	else if(intState == 1){

		grpAlbmArt.Hide();
		grpSonginfo.Show();
	}
	else if(intState == 2){

		grpAlbmArt.Show();
		grpSonginfo.Hide();
	}
	else if(intState == 3){

		grpAlbmArt.Hide();
		grpSonginfo.Hide();
	}


}

System.onScriptUnloading() {

	System.setPrivateInt("Rikka", "WindowState", intState);
}

btnAlbArt.onLeftButtonUp(int x, int y) {


	if (intState == 0){

		grpAlbmArt.Hide();
		grpSonginfo.Show();
	}
	else if(intState == 1){

		grpAlbmArt.Show();
		grpSonginfo.Hide();
	}
	else if(intState == 2){

		grpAlbmArt.Hide();
		grpSonginfo.Hide();
	}
	else if(intState == 3){

		grpAlbmArt.Show();
		grpSonginfo.Show();
	}
	
	System.setPrivateInt("Rikka", "WindowState", intState);

	intState ++;
	if(intState >=4) intState = 0;

}
