#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);


Global Group	grpMain;
Global Group	grpWindow;
Global Layer	lyrDrugWindow;
Global int	intPosX;
Global int	intPosY;
Global int	intObjH;
Global int	intObjW;
Global Boolean	blnDrg;


System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpWindow	= grpMain.getObject("Window.Group");
	lyrDrugWindow	= grpWindow.getObject("Window_dummy");
	intPosX		= System.getPrivateInt("RikkaW", "PosX", 0);
	intPosY		= System.getPrivateInt("RikkaW", "PosY", 0);
	intObjW		= grpWindow.getGuiW();
	intObjH		= grpWindow.getGuiH();

	fn_ReSizeGroup(grpWindow, intPosX, intPosY, intObjW, intObjH, 0.1, 0.1, 255);
}

System.onScriptUnloading(){

	System.setPrivateInt("RikkaW", "PosX", intPosX);
	System.setPrivateInt("RikkaW", "PosY", intPosY);
}

lyrDrugWindow.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intPosX = grpWindow.getLeft() - x;
	intPosY = grpWindow.getTop() - y;
}

lyrDrugWindow.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	intPosX = grpWindow.getLeft();
	intPosY = grpWindow.getTop();
}

lyrDrugWindow.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpWindow.setXmlParam("x", integerToString(x + intPosX));
	grpWindow.setXmlParam("y", integerToString(y + intPosy));
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}