#include "std.mi"

Function fn_FrameSet(int f);
Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);

//---------- Wip Action --------------------
Global Group	grpMain;
Global Group	grpCharaCG;
Global Layer	lyrCharaCG;
Global Map	mapCharaCGMap;
Global Int	intValueMax;
Global Int	intValueMin;
Global Int	intValue;
Global Int	intCGNumber;
Global Timer	tmrLoadCharaCG;
Global Timer	tmrShowCharaCG;

//----------  --------------------
Global Int	intShowFlag;
Global Int	intPlayStatus;
Global Int	intPlayItemLength;
Global Int	intCurrentPostion;
Global Timer	tmrSongPos;

System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpCharaCG	= grpMain.findObject("CharaCG.Group");
	lyrCharaCG	= grpMain.findObject("CharaCG");

	mapCharaCGMap = new Map;
	mapCharaCGMap.loadMap("CharaCGMap");

	tmrLoadCharaCG	= new Timer;
	tmrShowCharaCG	= new Timer;
	tmrSongPos	= new Timer;

     //STATUS_PAUSED (-1), STATUS_STOPPED (0), STATUS_PLAYING (1)
	if(getStatus() == 1) intPlayStatus = 1;
	else if(getStatus() == -1) intPlayStatus = 0;
	else if(getStatus() == 0) intPlayStatus = 0;

	tmrSongPos.setDelay(50);
	tmrSongPos.start();
}

System.onScriptUnloading() {

	tmrLoadCharaCG.stop();
	delete tmrLoadCharaCG;

	tmrShowCharaCG.stop();
	delete tmrShowCharaCG;

	tmrSongPos.stop();
	delete tmrSongPos;

	delete mapCharaCGMap;
}

System.onTitleChange(String newtitle) {

	intValueMax = 0;
	intValueMin = -1;
	intShowFlag = 0;
	fn_FrameSet(0);
	lyrCharaCG.setAlpha(0);
}

tmrSongPos.onTimer() {

	tmrSongPos.stop();

	intPlayItemLength = System.getPlayItemLength();
	intPlayItemLength = intPlayItemLength / 2;
	intCurrentPostion = System.getPosition();

	if(intShowFlag == 0) {
		if(intCurrentPostion >= intPlayItemLength) {
			intValueMax = 0;
			intValueMin = -1;
			intShowFlag = 1;
			tmrLoadCharaCG.setDelay(50);
			tmrLoadCharaCG.start();
		}
	}

	if(intPlayStatus == 1) {
		tmrSongPos.setDelay(50);
		tmrSongPos.start();
	}
}

System.onStop() {

	tmrSongPos.stop();
}

System.onPause() {

	tmrSongPos.stop();
}

System.onPlay() {

	tmrSongPos.setDelay(50);
	tmrSongPos.start();
}

System. onResume() {

	tmrSongPos.setDelay(50);
	tmrSongPos.start();
}

tmrLoadCharaCG.onTimer() {

	tmrLoadCharaCG.stop();

	if(intCGNumber == 0) {
		fn_ReSizeGroup(grpCharaCG, 0, 0, 400, 900, 0.1, 0.1, 255);
	}
	else if(intCGNumber == 1) {
		fn_ReSizeGroup(grpCharaCG, 0, -300, 400, 900, 0.1, 0.1, 255);
	}
	else if(intCGNumber == 2) {
		fn_ReSizeGroup(grpCharaCG, 0, -600, 400, 900, 0.1, 0.1, 255);
	}

	intCGNumber ++;
	if(intCGNumber >= 3) intCGNumber = 0;

	tmrShowCharaCG.setDelay(50);
	tmrShowCharaCG.start();
}

tmrShowCharaCG.onTimer() {

	tmrShowCharaCG.stop();
 
	if(intvalueMin == 0) {
		lyrCharaCG.setAlpha(0);
		intShowFlag = 2;
	}
	else if(intvalueMax == 31) {
		fn_FrameSet(30);
		intvalueMax = 32;
		intvalueMin = 30;
		lyrCharaCG.setAlpha(255);

		intPlayItemLength = System.getPlayItemLength();
		intPlayItemLength = intPlayItemLength / 5;

		tmrShowCharaCG.setDelay(intPlayItemLength);
		tmrShowCharaCG.start();
	}
	else if(intvalueMax <= 30) {
		intvalueMax ++;
		intValue = intvalueMax;
		fn_FrameSet(intValue);
		lyrCharaCG.setAlpha(255);
		tmrShowCharaCG.setDelay(50);
		tmrShowCharaCG.start();
	}
	else if(intvalueMin >= 1) {
		intvalueMin --;
		intValue  = intvalueMin;
		fn_FrameSet(intValue);
		tmrShowCharaCG.setDelay(50);
		tmrShowCharaCG.start();
	}
}

fn_FrameSet(int Value) {

	Region r = new Region;
        r.loadFromMap(mapCharaCGMap, Value, 1);
	lyrCharaCG.setRegion(r);
	delete r;
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}