#include "std.mi"

Function fn_ObjReSize(Guiobject G, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);

Global Group		grpMain;
Global Group		grpSubButton;
Global Guiobject	recLineTop;
Global Guiobject	recLineBottom;
Global Guiobject	recLineMiddle;
Global Guiobject	recLineRight;
Global Guiobject	recLineLeft;
Global Guiobject	recLineMiddleH;
Global Button           btnPL;
Global Button           btnML;
Global Button           btnVideo;
Global Button		btnOpFile;
Global Button		btnOpFolder;
Global Button		btnVolUP;
Global Button		btnVolDown;
Global ToggleButton     tglShuffle;
Global ToggleButton     tglRepeat;
Global slider           sldSeek;
Global Int     		intRectPos;
Global Int     		intRectPosH;

System.onScriptLoaded(){

	grpMain		= getScriptGroup();
	grpSubButton	= grpMain.findObject("SubButtonWindow.Group");
	btnPL		= grpSubButton.findObject("pl");
	btnML		= grpSubButton.findObject("ml");
	btnVideo	= grpSubButton.findObject("video");
	btnOpFile	= grpSubButton.findObject("OpneFile");
	btnOpFolder	= grpSubButton.findObject("OpneFolder");
	tglShuffle	= grpSubButton.findObject("Shuffle");
	tglRepeat	= grpSubButton.findObject("Repeat");
	recLineTop	= grpMain.findObject("LineTop");
	recLineBottom	= grpMain.findObject("LineBottom");
	recLineMiddle	= grpMain.findObject("LineMiddle");
	recLineRight	= grpMain.findObject("LineRight");
	recLineLeft	= grpMain.findObject("LineLeft");
	recLineMiddleH	= grpMain.findObject("LineMiddleH");
	sldSeek		= grpMain.findObject("seek");
	btnVolUP	= grpMain.findObject("volumeup");
	btnVolDown	= grpMain.findObject("volumedown");
}

System.onScriptUnloading(){


}

//----------- onEnterArea() --------------

btnPL.onEnterArea() {
	fn_ObjReSize(recLineTop, 0, 26, 165, 1, 0.5, 0.5, 255);
	fn_ObjReSize(recLineBottom, 0, 10, 165, 1, 0.5, 0.5, 255);
	intRectPos = 1;
}
btnML.onEnterArea() {
	fn_ObjReSize(recLineTop, 0, 48, 165, 1, 0.5, 0.5, 255);
	fn_ObjReSize(recLineBottom, 0, 32, 165, 1, 0.5, 0.5, 255);
	intRectPos = 2;
}
btnVideo.onEnterArea() {
	fn_ObjReSize(recLineTop, 0, 70, 165, 1, 0.5, 0.5, 255);
	fn_ObjReSize(recLineBottom, 0, 54, 165, 1, 0.5, 0.5, 255);
	intRectPos = 3;
}
btnOpFile.onEnterArea() {
	fn_ObjReSize(recLineTop, 0, 92, 165, 1, 0.5, 0.5, 255);
	fn_ObjReSize(recLineBottom, 0, 76, 165, 1, 0.5, 0.5, 255);
	intRectPos = 4;

}
btnOpFolder.onEnterArea() {
	fn_ObjReSize(recLineTop, 0, 114, 165, 1, 0.5, 0.5, 255);
	fn_ObjReSize(recLineBottom, 0, 98, 165, 1, 0.5, 0.5, 255);
	intRectPos = 5;
}
tglShuffle.onEnterArea() {
	fn_ObjReSize(recLineTop, 0, 136, 165, 1, 0.5, 0.5, 255);
	fn_ObjReSize(recLineBottom, 0, 120, 165, 1, 0.5, 0.5, 255);
	intRectPos = 6;
}
tglRepeat.onEnterArea() {
	fn_ObjReSize(recLineTop, 0, 158, 148, 1, 0.5, 0.5, 255);
	fn_ObjReSize(recLineBottom, 0, 142, 165, 1, 0.5, 0.5, 255);
	intRectPos = 7;
}
sldSeek.onEnterArea() {
	fn_ObjReSize(recLineRight, 130, 0, 1, 175, 0.5, 0.5, 255);
	fn_ObjReSize(recLineLeft, 145, 0, 1, 175, 0.5, 0.5, 255);
	intRectPosH = 1;
}
btnVolUP.onEnterArea() {
	fn_ObjReSize(recLineRight, 146, 0, 1, 175, 0.5, 0.5, 255);
	fn_ObjReSize(recLineLeft, 162, 0, 1, 175, 0.5, 0.5, 255);
	intRectPosH = 2;
}
btnVolDown.onEnterArea() {
	fn_ObjReSize(recLineRight, 146, 0, 1, 175, 0.5, 0.5, 255);
	fn_ObjReSize(recLineLeft, 162, 0, 1, 175, 0.5, 0.5, 255);
	intRectPosH = 3;
}

//----------- onLeaveArea() --------------

btnPL.onLeaveArea() {
	fn_ObjReSize(recLineTop, 0, 0, 165, 1, 1.0, 1.0, 255);
	fn_ObjReSize(recLineBottom, 0, 175, 165, 1, 1.0, 1.0, 255);
	intRectPos = 0;
}
btnML.onLeaveArea() {
	fn_ObjReSize(recLineTop, 0, 0, 165, 1, 1.0, 1.0, 255);
	fn_ObjReSize(recLineBottom, 0, 175, 165, 1, 1.0, 1.0, 255);
	intRectPos = 0;
}
btnVideo.onLeaveArea() {
	fn_ObjReSize(recLineTop, 0, 0, 165, 1, 1.0, 1.0, 255);
	fn_ObjReSize(recLineBottom, 0, 175, 165, 1, 1.0, 1.0, 255);
	intRectPos = 0;
}
btnOpFile.onLeaveArea() {
	fn_ObjReSize(recLineTop, 0, 0, 165, 1, 1.0, 1.0, 255);
	fn_ObjReSize(recLineBottom, 0, 175, 165, 1, 1.0, 1.0, 255);
	intRectPos = 0;
}
btnOpFolder.onLeaveArea() {
	fn_ObjReSize(recLineTop, 0, 0, 165, 1, 1.0, 1.0, 255);
	fn_ObjReSize(recLineBottom, 0, 175, 165, 1, 1.0, 1.0, 255);
	intRectPos = 0;
}
tglShuffle.onLeaveArea() {
	fn_ObjReSize(recLineTop, 0, 0, 165, 1, 1.0, 1.0, 255);
	fn_ObjReSize(recLineBottom, 0, 175, 165, 1, 1.0, 1.0, 255);
	intRectPos = 0;
}
tglRepeat.onLeaveArea() {
	fn_ObjReSize(recLineTop, 0, 0, 165, 1, 1.0, 1.0, 255);
	fn_ObjReSize(recLineBottom, 0, 175, 165, 1, 1.0, 1.0, 255);
	intRectPos = 0;
}
sldSeek.onLeaveArea() {
	fn_ObjReSize(recLineRight, 165, 0, 1, 175, 0.5, 0.5, 255);
	fn_ObjReSize(recLineLeft, 0, 0, 1, 175, 1.0, 1.0, 255);
	intRectPosH = 0;
}
btnVolUP.onLeaveArea() {
	fn_ObjReSize(recLineRight, 165, 0, 1, 175, 0.5, 0.5, 255);
	fn_ObjReSize(recLineLeft, 0, 0, 1, 175, 0.5, 0.5, 255);
	intRectPosH = 0;
}
btnVolDown.onLeaveArea() {
	fn_ObjReSize(recLineRight, 165, 0, 1, 175, 0.5, 0.5, 255);
	fn_ObjReSize(recLineLeft, 0, 0, 1, 175, 0.5, 0.5, 255);
	intRectPosH = 0;
}

recLineTop.onTargetReached() {

	if(intRectPos == 0) fn_ObjReSize(recLineMiddle, 0, -16, 165, 16, 0.1, 0.1, 0);
	else if(intRectPos == 1) fn_ObjReSize(recLineMiddle, 0, 10, 165, 16, 0.3, 0.3, 100);
	else if(intRectPos == 2) fn_ObjReSize(recLineMiddle, 0, 32, 165, 16, 0.3, 0.3, 100);
	else if(intRectPos == 3) fn_ObjReSize(recLineMiddle, 0, 54, 165, 16, 0.3, 0.3, 100);
	else if(intRectPos == 4) fn_ObjReSize(recLineMiddle, 0, 76, 165, 16, 0.3, 0.3, 100);
	else if(intRectPos == 5) fn_ObjReSize(recLineMiddle, 0, 98, 165, 16, 0.3, 0.3, 100);
	else if(intRectPos == 6) fn_ObjReSize(recLineMiddle, 0, 120, 165, 16, 0.3, 0.3, 100);
	else if(intRectPos == 7) fn_ObjReSize(recLineMiddle, 0, 142, 165, 16, 0.3, 0.3, 100);
}

recLineRight.onTargetReached() {
	if(intRectPosH == 0) fn_ObjReSize(recLineMiddleH, 130, 0, 15, 175, 0.1, 0.1, 0);
	else if(intRectPosH == 1) fn_ObjReSize(recLineMiddleH, 130, 0, 16, 175, 0.3, 0.3, 100);
	else if(intRectPosH == 2) fn_ObjReSize(recLineMiddleH, 146, 0, 16, 175, 0.3, 0.3, 100);
	else if(intRectPosH == 3) fn_ObjReSize(recLineMiddleH, 146, 0, 16, 175, 0.3, 0.3, 100);
}

fn_ObjReSize(Guiobject G, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA) {

	G.setTargetX(TargetX);
        G.setTargetY(TargetY);
        G.setTargetW(TargetW);
        G.setTargetH(TargetH);
        G.setTargetSpeed(SpeedW);
        G.setTargetSpeed(SpeedH);
        G.setTargetA(TargetA);
        G.gotoTarget();
}