#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);
Function fn_ReSizeLayer(Layer l, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);
Function fn_ReSizeButton(Button b, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);
Function fn_FrameSet(int f);

Global Group		grpMain;
Global Group		grpTop;
Global Group		grpIoriFullTachi;
Global Group		grpSelenLogo;
Global AnimatedLayer	AniBigChara;
Global AnimatedLayer	AniIoriFullTachi;
Global AnimatedLayer	AniIoriFullTachiFace;
Global Layer		lyrTopTitle;
Global Map		mapTopTitle;
Global Int              intValueMax;
Global Int              intValue;
Global Int              intBigCharaCut;
Global Int              intIoriFullTachi;
Global Timer            tmrMapValue;
Global Timer		tmrAnime;
Global Button		btnStart;

System.onScriptLoaded(){

	grpMain 		= getScriptGroup();
	grpTop			= grpMain.findObject("Top.Group");
	grpIoriFullTachi	= grpTop.findObject("IoriFullTachi.Group");
	grpSelenLogo		= grpTop.findObject("SelenLogo.Group");
	AniIoriFullTachi	= grpTop.findObject("IoriFullTachi");
	AniIoriFullTachiFace	= grpTop.findObject("IoriFullTachiFace");
	lyrTopTitle		= grpMain.findObject("TopTitle");
	btnStart		= grpMain.findObject("Start_button");
	intBigCharaCut	 	= System.getPrivateInt("Haramiko_Iori", "BigCharaCut", 0);

	mapTopTitle = new Map;
	mapTopTitle.loadMap("TopTitleMap");

	tmrMapValue	= new Timer;
	tmrAnime	= new Timer;

//	intBigCharaCut = 1;

	if(intBigCharaCut == 0){
		fn_ReSizeGroup(grpIoriFullTachi, 30, -370, 500, 670, 0.1, 0.1, 255);
	}
	else if(intBigCharaCut == 1){
		fn_ReSizeGroup(grpIoriFullTachi, -100, -370, 500, 670, 0.1, 0.1, 255);
	}
	else if(intBigCharaCut == 2){
		fn_ReSizeGroup(grpIoriFullTachi, 30, -370, 500, 670, 0.1, 0.1, 255);
	}
	tmrAnime.setDelay(50);
	tmrAnime.start();
}

System.onScriptUnloading(){

	System.setPrivateInt("Haramiko_Iori", "BigCharaCut", intBigCharaCut);

	tmrAnime.Stop();
	delete tmrAnime;

	tmrMapValue.Stop();
	delete tmrMapValue;

	delete mapTopTitle;

}

tmrAnime.onTimer(){

	tmrAnime.Stop();

	fn_ReSizeGroup(grpSelenLogo, 347, 247, 50, 52, 1.0, 1.0, 255);

	if(intBigCharaCut == 0){
		fn_ReSizeGroup(grpIoriFullTachi, 30, -10, 500, 670, 4.0, 4.0, 255);
		AniIoriFullTachi.gotoFrame(1);
		intIoriFullTachi = 1;
	}
	else if(intBigCharaCut == 1){
		fn_ReSizeGroup(grpIoriFullTachi, 35, -16, 500, 670, 4.0, 4.0, 255);
		AniIoriFullTachi.gotoFrame(2);
		intIoriFullTachi = 1;
	}
	else if(intBigCharaCut == 2){
		fn_ReSizeGroup(grpIoriFullTachi, 30, -10, 500, 670, 4.0, 4.0, 255);
		AniIoriFullTachi.gotoFrame(3);
		intIoriFullTachi = 1;
	}
	tmrMapValue.setDelay(2000);
	tmrMapValue.start();
}

grpIoriFullTachi.onTargetReached(){

	if(intIoriFullTachi == 1){
		fn_ReSizeButton(btnStart, 10, 150, 130, 20, 0.1, 0.1, 255);
		if(intBigCharaCut == 0){
			AniIoriFullTachiFace.gotoFrame(1);
			intBigCharaCut = 1;
		}
		else if(intBigCharaCut == 1){
			AniIoriFullTachiFace.gotoFrame(2);
			intBigCharaCut = 2;
		}
		else if(intBigCharaCut == 2){
			AniIoriFullTachiFace.gotoFrame(3);
			intBigCharaCut = 0;
		}
	}

}

tmrMapValue.onTimer() {

	tmrMapValue.stop();

	if(intvalueMax == 31) {
		intValue = 30;
		fn_FrameSet(intValue);
	}
	else if(intvalueMax <= 30) {
		intvalueMax ++;
		intValue = intvalueMax;
		fn_FrameSet(intValue);
		lyrTopTitle.setAlpha(255);

		tmrMapValue.setDelay(50);
		tmrMapValue.start();
	}
}

btnStart.onleftbuttonUp(int x, int y){

	fn_ReSizeGroup(grpTop, 0, 0, 400, 300, 1.0, 1.0, 0);
}
grpTop.onTargetReached(){

	grpTop.Hide();
}


fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}
fn_ReSizeLayer(Layer l, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

        l.setTargetX(TargetX);
        l.setTargetY(TargetY);
        l.setTargetW(TargetW);
        l.setTargetH(TargetH);
        l.setTargetSpeed(SpeedW);
        l.setTargetSpeed(SpeedH);
        l.setTargetA(TargetA);
        l.gotoTarget();
}
fn_ReSizeButton(Button b, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

        b.setTargetX(TargetX);
        b.setTargetY(TargetY);
        b.setTargetW(TargetW);
        b.setTargetH(TargetH);
        b.setTargetSpeed(SpeedW);
        b.setTargetSpeed(SpeedH);
        b.setTargetA(TargetA);
        b.gotoTarget();
}
fn_FrameSet(int Value) {
        Region r = new Region;
        r.loadFromMap(mapTopTitle, Value, 1);
        lyrTopTitle.setRegion(r);
        delete r;
}