#include "std.mi"

Function fn_FrameSet(int f);
Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);


Global Group	grpMain;
Global Group	grpCharaCG;
Global Group	grpWipCG;
Global Layer	lyrCharaCG;
Global Int	intCharaCGNumber;
Global Int	intPlayItemLength;
Global Int	intCurrentPostion;
Global Int	intWipMode;
Global Int	intPlayStatus;
Global Int	intPostionCount;
Global Timer	tmrShowCharaCG;
Global Timer	tmrCharaCGMapNumber;
Global Timer	tmrCurrentPostion;
//Global Text	TextPlayItemLength;
//Global Text	TextCurrentPostion;

//---------- Wip Action --------------------
Global Layer	lyrWipCG;
Global Map	mapWipMap;
Global Int	intValueMax;
Global Int	intValueMin;
Global Int	intValue;
Global Int	intWipCGNumber;
Global Int	intWipMapNumber;
Global Timer	tmrLoadWipCG;
Global Timer	tmrLoadWipMap;
Global Timer	tmrWipAction;


System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpCharaCG	= grpMain.findObject("CharaCG.Group");
	grpWipCG	= grpMain.findObject("WipCG.Group");
	lyrWipCG	= grpMain.findObject("wipCG1");
	lyrCharaCG	= grpMain.findObject("CharaCG");
//	TextPlayItemLength	= getContainer("main").getLayout("normal").getObject("PlayItemLength");
//	TextCurrentPostion	= getContainer("main").getLayout("normal").getObject("CurrentPostion");

	tmrLoadWipCG		= new Timer;
	tmrLoadWipMap		= new Timer;
	tmrWipAction		= new Timer;
	tmrShowCharaCG		= new Timer;
	tmrCharaCGMapNumber	= new Timer;
	tmrCurrentPostion	= new Timer;

	tmrCurrentPostion.setDelay(50);
	tmrCurrentPostion.start();

//vCԊmF STATUS_PAUSED (-1), STATUS_STOPPED (0), STATUS_PLAYING (1)

	if(getStatus() == 1) intPlayStatus = 0;
	else if(getStatus() == -1) intPlayStatus = 1;
	else if(getStatus() == 0) intPlayStatus = 1;
}

System.onScriptUnloading() {

	tmrLoadWipCG.stop();
	delete tmrLoadWipCG;

	tmrLoadWipMap.stop();
	delete tmrLoadWipMap;

	tmrWipAction.stop();
	delete tmrWipAction;

	tmrShowCharaCG.stop();
	delete tmrShowCharaCG;

	tmrCharaCGMapNumber.stop();
	delete tmrCharaCGMapNumber;

	tmrCurrentPostion.stop();
	delete tmrCurrentPostion;

	delete mapWipMap;
}

System.onTitleChange(String newtitle) {

	if(getStatus() == 1){
		intValueMax = 0;
		intValueMin = -1;
		tmrLoadWipCG.setDelay(50);
		tmrLoadWipCG.start();
	}

	intPostionCount = 0;
}

tmrCurrentPostion.onTimer() {

	tmrCurrentPostion.stop();

	intPlayItemLength = System.getPlayItemLength();
	intPlayItemLength = intPlayItemLength / 2;
	intCurrentPostion = System.getPosition();

//	TextPlayItemLength.setText(System.integerToTime(System.getPlayItemLength()));
//	TextCurrentPostion.setText(System.integerToTime(System.getPosition()));

	if(intPostionCount == 0) {
		if(intCurrentPostion >= intPlayItemLength) {
			intPostionCount = 1;
			tmrShowCharaCG.setDelay(50);
			tmrShowCharaCG.start();
		}
	}

	tmrCurrentPostion.setDelay(50);
	tmrCurrentPostion.start();
}

tmrLoadWipCG.onTimer() {

	tmrLoadWipCG.stop();

	intWipMode = 0;

	if(intWipCGNumber == 0) {
		fn_ReSizeGroup(grpWipCG, 0, 0, 400, 900, 0.1, 0.1, 255);
	}
	else if(intWipCGNumber == 1) {
		fn_ReSizeGroup(grpWipCG, 0, -300, 400, 900, 0.1, 0.1, 255);
	}
	else if(intWipCGNumber == 2) {
		fn_ReSizeGroup(grpWipCG, 0, -600, 400, 900, 0.1, 0.1, 255);
	}
	intWipCGNumber ++;
	if(intWipCGNumber >= 3) intWipCGNumber = 0;

	tmrLoadWipMap.setDelay(50);
	tmrLoadWipMap.start();
}

tmrLoadWipMap.onTimer() {

	tmrLoadWipMap.stop();

	delete mapWipMap;
	mapWipMap = new Map;

	intWipMapNumber = 0;

	if(intWipMapNumber == 0) mapWipMap.loadMap("Map1");

	tmrWipAction.setDelay(50);
	tmrWipAction.start();
}

tmrShowCharaCG.onTimer() {

	tmrShowCharaCG.stop();

	intValueMax = 0;
	intValueMin = -1;
	intWipMode = 1;

	if(intCharaCGNumber == 0) {
		fn_ReSizeGroup(grpCharaCG, 0, 0, 400, 1200, 0.1, 0.1, 255);
	}
	else if(intCharaCGNumber == 1) {
		fn_ReSizeGroup(grpCharaCG, 0, -300, 400, 1200, 0.1, 0.1, 255);
	}
	else if(intCharaCGNumber == 2) {
		fn_ReSizeGroup(grpCharaCG, 0, -600, 400, 1200, 0.1, 0.1, 255);
	}
	else if(intCharaCGNumber == 3) {
		fn_ReSizeGroup(grpCharaCG, 0, -900, 400, 1200, 0.1, 0.1, 255);
	}

	intCharaCGNumber ++;
	if(intCharaCGNumber >= 4) intCharaCGNumber = 0;

	tmrCharaCGMapNumber.setDelay(1000);
	tmrCharaCGMapNumber.start();
}

tmrCharaCGMapNumber.onTimer() {

	tmrCharaCGMapNumber.stop();

	delete mapWipMap;
	mapWipMap = new Map;
	mapWipMap.loadMap("CharaCGMap");

	tmrWipAction.setDelay(50);
	tmrWipAction.start();
}

tmrWipAction.onTimer() {

	tmrWipAction.stop();
 
	if(intvalueMin == 0) {
		if(intWipMode == 0) lyrWipCG.setAlpha(0);
		else if(intWipMode == 1) lyrCharaCG.setAlpha(0);
	}
	else if(intvalueMax == 31) {
		fn_FrameSet(30);
		intvalueMax = 32;
		intvalueMin = 30;

		if(intWipMode == 0) {
			lyrWipCG.setAlpha(255);
			lyrCharaCG.setAlpha(0);
			tmrWipAction.setDelay(50);
			tmrWipAction.start();
		}
		else if(intWipMode == 1) {
			intPlayItemLength = System.getPlayItemLength();
			intPlayItemLength = intPlayItemLength / 3;
			lyrCharaCG.setAlpha(255);
			tmrWipAction.setDelay(intPlayItemLength);
			tmrWipAction.start();
		}

	}
	else if(intvalueMax <= 30) {
		intvalueMax ++;
		intValue = intvalueMax;
		fn_FrameSet(intValue);
		if(intWipMode == 0) lyrWipCG.setAlpha(255);
		else if(intWipMode == 1) lyrCharaCG.setAlpha(255);
		tmrWipAction.setDelay(50);
		tmrWipAction.start();
	}
	else if(intvalueMin >= 1) {
		intvalueMin --;
		intValue  = intvalueMin;
		fn_FrameSet(intValue);
		tmrWipAction.setDelay(50);
		tmrWipAction.start();
	}
}

System.onStop() {

	tmrWipAction.stop();
	if(intWipMode == 0) lyrWipCG.setAlpha(0);
	else if(intWipMode == 1) lyrCharaCG.setAlpha(0);
}

System.onPause() {

	if(intWipMode == 1) {

		if(intCharaCGNumber == 0) {
			intCharaCGNumber = 1;
		}
		else if(intCharaCGNumber == 1) {
			intCharaCGNumber = 0;
		}
	}

	tmrWipAction.stop();
	if(intWipMode == 0) lyrWipCG.setAlpha(0);
	else if(intWipMode == 1) lyrCharaCG.setAlpha(0);
}

System.onPlay() {

		intValueMax = 0;
		intValueMin = -1;

		intPlayItemLength = System.getPlayItemLength();
		intPlayItemLength = intPlayItemLength / 2;

		tmrShowCharaCG.setDelay(intPlayItemLength);
		tmrShowCharaCG.start();
}

System. onResume() {

		intValueMax = 0;
		intValueMin = -1;

		intPlayItemLength = System.getPlayItemLength();
		intPlayItemLength = intPlayItemLength / 2;

		tmrShowCharaCG.setDelay(intPlayItemLength);
		tmrShowCharaCG.start();

}

/*****************************************************************************************************************************
//֐
*****************************************************************************************************************************/
fn_FrameSet(int Value) {

	if(intWipMode == 0) {
		Region r = new Region;
        	r.loadFromMap(mapWipMap, Value, 1);
		lyrWipCG.setRegion(r);
		delete r;
	}
	else if(intWipMode == 1) {
		Region r = new Region;
        	r.loadFromMap(mapWipMap, Value, 1);
		lyrCharaCG.setRegion(r);
		delete r;
	}
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}