#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);

//------------- AniCharacter ----------------
Global Group		grpMain;
Global Group		grpAniChara;
Global AnimatedLayer	AniChara;
Global AnimatedLayer	AniCharaFace;
Global Timer		tmrVu;
Global Timer		tmrTachiChange;
Global Int		intVuLevel;
Global Int		intTachiPattern;
Global Button           btnMini;
Global Button           btnClose;
Global Button           btnPrev;
Global Button           btnPlay;
Global Button           btnPause;
Global Button           btnStop;
Global Button           btnNext;
Global Int		intgrpAniCharaStat;
Global Int		intClickCount;
Global Group		grpItem01;
Global Int		intgrpItem01Stat;
Global Group		grpItem02;
Global Int		intgrpItem02Stat;

//------------- AniBGCG ----------------
Global AnimatedLayer	AniBGCG;
Global Int		intBGCGNomber;
Global Timer		tmrBGCGChange;

//------------- CurrentTime ----------------
Global Int		intCurrentTime;
Global Int		intWearPattern;
Global Int		intTimePattern;

System.onScriptLoaded() {

	grpMain 	= getScriptGroup();
	grpAniChara	= grpMain.findObject("AniChara.Group");
	AniChara	= grpMain.findObject("AniChara");
	AniCharaFace	= grpMain.findObject("AniCharaFace");
	btnMini		= grpMain.findObject("Minimize");
	btnClose	= grpMain.findObject("Close");
	btnPrev		= grpMain.findObject("Previous");
	btnPlay		= grpMain.findObject("Play");
	btnPause	= grpMain.findObject("Pause");
	btnStop		= grpMain.findObject("Stop");
	btnNext		= grpMain.findObject("Next");
	AniBGCG		= getContainer("main").getLayout("normal").getObject("MainBackImage");
	grpItem01	= grpMain.findObject("Item01.Group");
	grpItem02	= grpMain.findObject("Item02.Group");

	intTachiPattern	 	= System.getPrivateInt("Haramiko_Iori", "TachiPattern", 0);

	tmrVu	 = new Timer;
	tmrTachiChange	 = new Timer;
	tmrBGCGChange	 = new Timer;

	tmrVu.setDelay(50);
	tmrVu.start();

	tmrTachiChange.setDelay(100);
	tmrTachiChange.start();
}

System.onScriptUnloading() {

	System.setPrivateInt("Haramiko_Iori", "TachiPattern", intTachiPattern);

	tmrVu.stop();
	delete tmrVu;

	tmrTachiChange.stop();
	delete tmrTachiChange;

	tmrBGCGChange.stop();
	delete tmrBGCGChange;
}

System.onTitleChange(String newtitle) {

	tmrTachiChange.setDelay(1900);
	tmrTachiChange.start();
}

tmrTachiChange.onTimer() {

	tmrTachiChange.stop();

	intTachiPattern ++;
	if(intTachiPattern >= 3) intTachiPattern = 0;

	if(intTachiPattern == 2) {
		if(intWearPattern == 0) AniChara.gotoFrame(13);
		else if(intWearPattern == 2) AniChara.gotoFrame(14);
		else if(intWearPattern == 4) AniChara.gotoFrame(15);
		else if(intWearPattern == 6) AniChara.gotoFrame(16);
		else if(intWearPattern == 8) AniChara.gotoFrame(17);
		else if(intWearPattern == 10) AniChara.gotoFrame(18);
		AniCharaFace.gotoFrame(31);
	}
	else if(intTachiPattern == 0) {
		AniChara.gotoFrame(intWearPattern + 1);
		AniCharaFace.gotoFrame(1);
	}
	else if(intTachiPattern == 1) {
		AniChara.gotoFrame(intWearPattern + 2);
		AniCharaFace.gotoFrame(1);
	}

	tmrBGCGChange.setDelay(50);
	tmrBGCGChange.start();
}

tmrBGCGChange.onTimer() {

	tmrBGCGChange.stop();

	int intBGCGRandom;

	if(intWearPattern == 0) {
		intBGCGRandom =Random(4);
		if(intBGCGRandom == 0) AniBGCG.gotoFrame(2);
		else if(intBGCGRandom == 1) AniBGCG.gotoFrame(3);
		else if(intBGCGRandom == 2) AniBGCG.gotoFrame(4);
		else if(intBGCGRandom == 3) AniBGCG.gotoFrame(5);
	}
	else if(intWearPattern == 2) {
		if(intTimePattern == 1) {
			intBGCGRandom =Random(4);
			if(intBGCGRandom == 0) AniBGCG.gotoFrame(2);
			else if(intBGCGRandom == 1) AniBGCG.gotoFrame(3);
			else if(intBGCGRandom == 2) AniBGCG.gotoFrame(5);
			else if(intBGCGRandom == 3) AniBGCG.gotoFrame(7);
		}
		else if(intTimePattern == 2) {
			intBGCGRandom =Random(2);
			if(intBGCGRandom == 0) AniBGCG.gotoFrame(6);
			else if(intBGCGRandom == 1) AniBGCG.gotoFrame(7);
		}
	}
	else if(intWearPattern == 4) {
		intBGCGRandom =Random(4);
		if(intBGCGRandom == 0) AniBGCG.gotoFrame(8);
		else if(intBGCGRandom == 1) AniBGCG.gotoFrame(9);
		else if(intBGCGRandom == 2) AniBGCG.gotoFrame(7);
		else if(intBGCGRandom == 3) AniBGCG.gotoFrame(6);
	}
	else if(intWearPattern == 6) {
		AniBGCG.gotoFrame(4);
	}
	else if(intWearPattern == 8) {
		intBGCGRandom =Random(2);
		if(intBGCGRandom == 0) AniBGCG.gotoFrame(6);
		else if(intBGCGRandom == 1) AniBGCG.gotoFrame(7);
	}
	else if(intWearPattern == 10) {
		intBGCGRandom =Random(2);
		if(intBGCGRandom == 0) AniBGCG.gotoFrame(6);
		else if(intBGCGRandom == 1) AniBGCG.gotoFrame(7);
	}
}

tmrVu.onTimer() {

	tmrVu.stop();

	intClickCount = 0;

	intVuLevel = ((System.getLeftVuMeter() + System.getRightVuMeter())/2);


	if(intTachiPattern == 2) {
		fn_ReSizeGroup(grpItem01, 290, 75, 50, 50, 0.1, 0.1, 0);
		fn_ReSizeGroup(grpItem02, 290, 75, 50, 50, 0.1, 0.1, 0);
	}
	else if(intTachiPattern >= 0) {
		fn_ReSizeGroup(grpItem01, 320, 65, 50, 50, 0.1, 0.1, 0);
		fn_ReSizeGroup(grpItem02, 320, 65, 50, 50, 0.1, 0.1, 0);
	}

	if(intTachiPattern == 2) {
		if(intVuLevel == 0) {
			AniCharaFace.gotoFrame(31);
		}
		else if(intVuLevel > 0 && intVuLevel <= 60) {
			AniCharaFace.gotoFrame(42);
		}
		else if(intVuLevel > 60 && intVuLevel <= 120) {
			AniCharaFace.gotoFrame(39);
		}
		else if(intVuLevel > 120 && intVuLevel <= 180) {
			AniCharaFace.gotoFrame(33);
			fn_ReSizeGroup(grpItem01, 360, 25, 50, 50, 0.9, 0.9, 255);
			intgrpAniCharaStat = 1;
			intgrpItem01Stat = 1;
		}
		else if(intVuLevel > 180) {
			AniCharaFace.gotoFrame(33);
			fn_ReSizeGroup(grpAniChara, 9, -10, 500, 350, 0.3, 0.3, 255);
			fn_ReSizeGroup(grpItem02, 360, 25, 50, 50, 0.9, 0.9, 255);
			intgrpAniCharaStat = 1;
			intgrpItem02Stat = 1;
		}
	}
	else if(intTachiPattern >= 0) {
		if(intVuLevel == 0) {
			AniCharaFace.gotoFrame(18);
		}
		else if(intVuLevel > 0 && intVuLevel <= 60) {
			AniCharaFace.gotoFrame(14);
		}
		else if(intVuLevel > 60 && intVuLevel <= 120) {
			AniCharaFace.gotoFrame(24);
		}
		else if(intVuLevel > 120 && intVuLevel <= 180) {
			AniCharaFace.gotoFrame(15);
			fn_ReSizeGroup(grpItem01, 360, 25, 50, 50, 0.9, 0.9, 255);
			intgrpAniCharaStat = 1;
			intgrpItem01Stat = 1;
		}
		else if(intVuLevel > 180) {
			AniCharaFace.gotoFrame(15);
			fn_ReSizeGroup(grpAniChara, 9, -10, 500, 350, 0.3, 0.3, 255);
			fn_ReSizeGroup(grpItem02, 360, 25, 50, 50, 0.9, 0.9, 255);
			intgrpAniCharaStat = 1;
			intgrpItem02Stat = 1;
		}
	}

	intCurrentTime = System.getTimeOfDay();

	if((intCurrentTime > 28800000) && (intCurrentTime < 39600000)){	  //8`11

		intWearPattern = 0;
		intTimePattern = 0;
  	}
	if((intCurrentTime > 39600000) && (intCurrentTime < 43200000)){	  //11`12

		intWearPattern = 6;
		intTimePattern = 0;
  	}
	if((intCurrentTime > 43200000) && (intCurrentTime < 57600000)){	  //12`16

		intWearPattern = 0;
		intTimePattern = 0;
  	}
	if((intCurrentTime > 57600000) && (intCurrentTime < 61200000)){	  //16`17

		intWearPattern = 2;
		intTimePattern = 1;
	}
	if((intCurrentTime > 61200000) && (intCurrentTime < 64800000)){	  //17`18

		intWearPattern = 4;
		intTimePattern = 2;
	}
	if((intCurrentTime > 64800000) && (intCurrentTime < 75600000)){	  //18`21

		intWearPattern = 2;
		intTimePattern = 2;
	}
	if((intCurrentTime > 75600000) && (intCurrentTime < 79200000)){	  //21`22

		intWearPattern = 10;
		intTimePattern = 3;
	}
	if((intCurrentTime > 79200000) || (intCurrentTime < 28800000)){	  //22`8

		intWearPattern = 8;
		intTimePattern = 3;
	}


	tmrVu.setDelay(2000);
	tmrVu.start();

}

grpAniChara.onTargetReached(){

	if(intgrpAniCharaStat == 1) {
		fn_ReSizeGroup(grpAniChara, 9, -1, 500, 350, 0.2, 0.2, 255);
		intgrpAniCharaStat = 0;
	}
}

grpItem01.onTargetReached(){

	if(intgrpItem01Stat == 1) {
		fn_ReSizeGroup(grpItem01, 360, 25, 50, 50, 0.1, 0.1, 0);
		intgrpItem01Stat = 0;
	}
}

grpItem02.onTargetReached(){

	if(intgrpItem02Stat == 1) {
		fn_ReSizeGroup(grpItem02, 360, 25, 50, 50, 0.1, 0.1, 0);
		intgrpItem02Stat = 0;
	}
}
btnMini.onEnterArea() { 

	tmrVu.stop();

	if(intTachiPattern == 2) {
		AniCharaFace.gotoFrame(44);
		fn_ReSizeGroup(grpAniChara, 9, 5, 500, 350, 0.3, 0.3, 255);
	}
	else if(intTachiPattern == 0) {
		AniCharaFace.gotoFrame(22);
		fn_ReSizeGroup(grpAniChara, 9, 5, 500, 350, 0.3, 0.3, 255);
	}
	else if(intTachiPattern == 1) {
		AniCharaFace.gotoFrame(18);
		fn_ReSizeGroup(grpAniChara, 9, 5, 500, 350, 0.3, 0.3, 255);
	}
	intgrpAniCharaStat = 1;
}

btnMini.onLeaveArea() {  

	tmrVu.setDelay(50);
	tmrVu.start();
}

btnClose.onEnterArea() {

	tmrVu.stop();

	if(intTachiPattern == 2) {
		AniCharaFace.gotoFrame(38);
		fn_ReSizeGroup(grpAniChara, 9, 5, 500, 350, 0.3, 0.3, 255);
	}
	else if(intTachiPattern >= 0) {
		AniCharaFace.gotoFrame(13);
		fn_ReSizeGroup(grpAniChara, 9, -10, 500, 350, 0.3, 0.3, 255);
	}

	intgrpAniCharaStat = 1;
}

btnClose.onLeaveArea() {

	tmrVu.setDelay(50);
	tmrVu.start();
}

btnPrev.onEnterArea() {

	tmrVu.stop();

	if(intTachiPattern == 2) {
		AniCharaFace.gotoFrame(39);
		fn_ReSizeGroup(grpAniChara, 9, -10, 500, 350, 0.3, 0.3, 255);
	}
	else if(intTachiPattern >= 0) {
		AniCharaFace.gotoFrame(15);
		fn_ReSizeGroup(grpAniChara, 9, -10, 500, 350, 0.3, 0.3, 255);
	}

	intgrpAniCharaStat = 1;
}

btnPrev.onLeaveArea() {

	tmrVu.setDelay(50);
	tmrVu.start();
}

btnPlay.onEnterArea() {

	tmrVu.stop();

	if(intTachiPattern == 2) {
		AniCharaFace.gotoFrame(39);
		fn_ReSizeGroup(grpAniChara, 9, -10, 500, 350, 0.3, 0.3, 255);
	}
	else if(intTachiPattern >= 0) {
		AniCharaFace.gotoFrame(15);
		fn_ReSizeGroup(grpAniChara, 9, -10, 500, 350, 0.3, 0.3, 255);
	}

	intgrpAniCharaStat = 1;
}

btnPlay.onLeaveArea() {

	tmrVu.setDelay(50);
	tmrVu.start();
}

btnPause.onEnterArea() {

	tmrVu.stop();

	if(intTachiPattern == 2) {
		AniCharaFace.gotoFrame(41);
		fn_ReSizeGroup(grpAniChara, 9, 5, 500, 350, 0.3, 0.3, 255);
	}
	else if(intTachiPattern >= 0) {
		AniCharaFace.gotoFrame(21);
		fn_ReSizeGroup(grpAniChara, 9, 5, 500, 350, 0.3, 0.3, 255);
	}

	intgrpAniCharaStat = 1;
}

btnPause.onLeaveArea() {

	tmrVu.setDelay(50);
	tmrVu.start();
}

btnStop.onEnterArea() {

	tmrVu.stop();

	if(intTachiPattern == 2) {
		AniCharaFace.gotoFrame(41);
		fn_ReSizeGroup(grpAniChara, 9, 5, 500, 350, 0.3, 0.3, 255);
	}
	else if(intTachiPattern == 0) {
		AniCharaFace.gotoFrame(3);
		fn_ReSizeGroup(grpAniChara, 9, 5, 500, 350, 0.3, 0.3, 255);
	}
	else if(intTachiPattern == 1) {
		AniCharaFace.gotoFrame(29);
		fn_ReSizeGroup(grpAniChara, 9, 5, 500, 350, 0.3, 0.3, 255);
	}
	intgrpAniCharaStat = 1;
}

btnStop.onLeaveArea() {

	tmrVu.setDelay(50);
	tmrVu.start();
}

btnNext.onEnterArea() {

	tmrVu.stop();

	if(intTachiPattern == 2) {
		AniCharaFace.gotoFrame(39);
		fn_ReSizeGroup(grpAniChara, 9, -10, 500, 350, 0.3, 0.3, 255);
	}
	else if(intTachiPattern >= 0) {
		AniCharaFace.gotoFrame(15);
		fn_ReSizeGroup(grpAniChara, 9, -10, 500, 350, 0.3, 0.3, 255);
	}

	intgrpAniCharaStat = 1;
}

btnNext.onLeaveArea() {

	tmrVu.setDelay(50);
	tmrVu.start();
}

AniChara.onLeftButtonDown(int x, int y) {

	tmrVu.stop();

	intClickCount ++;

	if(intClickCount >= 10) intClickCount = 10;

	if(intTachiPattern == 2) {
		AniCharaFace.gotoFrame(37);
		fn_ReSizeGroup(grpAniChara, 9, -10, 500, 350, 0.3, 0.3, 255);
			if(intClickCount == 10) AniCharaFace.gotoFrame(30);
	}
	else if(intTachiPattern >= 0) {
		AniCharaFace.gotoFrame(26);
		fn_ReSizeGroup(grpAniChara, 9, -10, 500, 350, 0.3, 0.3, 255);
			if(intClickCount == 10) AniCharaFace.gotoFrame(20);
	}

	intgrpAniCharaStat = 1;

	tmrVu.setDelay(1000);
	tmrVu.start();
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}