#include "std.mi"

Function fn_FrameSet(int f);
Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);

Global Group	grpMain;
Global Group	grpWipCG;
Global Layer	lyrWipCG;
Global Map	mapWipMap;
Global Int	intValueMax;
Global Int	intValueMin;
Global Int	intValue;
Global Int	intWipCGNumber;
Global Timer	tmrLoadWipCG;
Global Timer	tmrWipAction;
Global String	strPlayStatas;

System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpWipCG	= grpMain.findObject("WipCG.Group");
	lyrWipCG	= grpMain.findObject("wipCG");

	mapWipMap = new Map;
	mapWipMap.loadMap("Map");

	tmrLoadWipCG	= new Timer;
	tmrWipAction	= new Timer;

     //STATUS_PAUSED (-1), STATUS_STOPPED (0), STATUS_PLAYING (1)
	if(getStatus() == 1) strPlayStatas = "strPlay";
	else if(getStatus() == -1) strPlayStatas = "strPlayPause";
	else if(getStatus() == 0) strPlayStatas = "strPlayStop";
}

System.onScriptUnloading() {

	tmrLoadWipCG.stop();
	delete tmrLoadWipCG;

	tmrWipAction.stop();
	delete tmrWipAction;

	delete mapWipMap;
}

System.onTitleChange(String newtitle) {

	if(strPlayStatas == "strPlay") {
		intValueMax = 0;
		intValueMin = -1;
		tmrLoadWipCG.setDelay(50);
		tmrLoadWipCG.start();
	}
	else if(strPlayStatas == "strResume") {
		intValueMax = 0;
		intValueMin = -1;
		tmrLoadWipCG.setDelay(50);
		tmrLoadWipCG.start();
	}
}

tmrLoadWipCG.onTimer() {

	tmrLoadWipCG.stop();

	if(intWipCGNumber == 0) {
		fn_ReSizeGroup(grpWipCG, 0, 0, 400, 900, 0.1, 0.1, 255);
	}
	else if(intWipCGNumber == 1) {
		fn_ReSizeGroup(grpWipCG, 0, -300, 400, 900, 0.1, 0.1, 255);
	}
	else if(intWipCGNumber == 2) {
		fn_ReSizeGroup(grpWipCG, 0, -600, 400, 900, 0.1, 0.1, 255);
	}

	intWipCGNumber ++;
	if(intWipCGNumber >= 3) intWipCGNumber = 0;

	tmrWipAction.setDelay(50);
	tmrWipAction.start();
}

tmrWipAction.onTimer() {

	tmrWipAction.stop();
 
	if(intvalueMin == 0) {
		lyrWipCG.setAlpha(0);
	}
	else if(intvalueMax == 31) {
		fn_FrameSet(30);
		intvalueMax = 32;
		intvalueMin = 30;

		lyrWipCG.setAlpha(255);
		tmrWipAction.setDelay(50);
		tmrWipAction.start();
	}
	else if(intvalueMax <= 30) {
		intvalueMax ++;
		intValue = intvalueMax;
		fn_FrameSet(intValue);
		lyrWipCG.setAlpha(255);
		tmrWipAction.setDelay(50);
		tmrWipAction.start();
	}
	else if(intvalueMin >= 1) {
		intvalueMin --;
		intValue  = intvalueMin;
		fn_FrameSet(intValue);
		tmrWipAction.setDelay(50);
		tmrWipAction.start();
	}
}

System.onStop() {

	strPlayStatas = "strStop";
}

System.onPause() {

	strPlayStatas = "strPause";
}

System.onPlay() {

	strPlayStatas = "strPlay";
}

System. onResume() {

	strPlayStatas = "strResume";
}

fn_FrameSet(int Value) {

	Region r = new Region;
        r.loadFromMap(mapWipMap, Value, 1);
	lyrWipCG.setRegion(r);
	delete r;
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}