#include "std.mi"

Function Fn_StartAnim(AnimatedLayer l, int start, int end, int speed);
Function Fn_ReSizeGroup(Group g, int TargetX, int TargetY, Float Speed, int TargetA);
Function Fn_ReSizeLayer(AnimatedLayer a, int TargetX, int TargetY, Float Speed, int TargetA);
Function Fn_ChangeImage();

Global Group		grpMain;
Global Group 		grpShuffle;
Global AnimatedLayer 	aniShuffle;
Global ToggleButton	tglShuffle;
Global Int		intShuffleState;     //0:Shuffle OFFA1:Shuffle ON
Global Int		intShuffleImage;

System.onScriptLoaded() {

	grpMain 	= getScriptGroup();
	grpShuffle	= grpMain.getObject("ShuffleButtons.Group");
	tglShuffle 	= grpShuffle.findObject("Shuffle");
	aniShuffle 	= grpShuffle.findObject("AniShuffle");

	intShuffleState	= System.getPrivateInt("LiveStageMiku", "ShuffleState", 0);

	if(intShuffleState == 0) Fn_StartAnim(AniShuffle, 0, 0, 0);
	else if(intShuffleState == 1) Fn_StartAnim(AniShuffle, 3, 3, 0);
}

tglShuffle.onToggle(boolean on) {

	if (on) {
		intShuffleState = 1;
	}
	else{
		intShuffleState = 0;
	}

	System.setPrivateInt("LiveStageMiku", "ShuffleState", intShuffleState);

}

tglShuffle.onLeftButtonDown(int x, int y) {

	if(intShuffleState == 0) Fn_StartAnim(AniShuffle, 1, 1, 0);
	else if(intShuffleState == 1) Fn_StartAnim(AniShuffle, 4, 4, 0);
	Fn_ReSizeGroup(grpShuffle, 136, 121, 0.1, 255);
}
tglShuffle.onLeftButtonUp(int x, int y) {

	if(intShuffleState == 0) Fn_StartAnim(AniShuffle, 1, 1, 0);
	else if(intShuffleState == 1) Fn_StartAnim(AniShuffle, 4, 4, 0);
	Fn_ReSizeGroup(grpShuffle, 135, 120, 0.1, 255);
}
tglShuffle.onEnterArea(){

	if(intShuffleState == 0) Fn_StartAnim(AniShuffle, 1, 1, 0);
	else if(intShuffleState == 1) Fn_StartAnim(AniShuffle, 4, 4, 0);
	Fn_ReSizeLayer(aniShuffle, 0, 0, 0.1, 255);
}
tglShuffle.onLeaveArea(){

	if(intShuffleState == 0) Fn_StartAnim(AniShuffle, 0, 0, 0);
	else if(intShuffleState == 1) Fn_StartAnim(AniShuffle, 3, 3, 0);
	Fn_ReSizeLayer(aniShuffle, 0, 0, 0.1, 255);
}
Fn_StartAnim(AnimatedLayer l, int start, int end, int speed){

	l.stop();
	l.setStartFrame(start);
	l.setEndFrame(end);
	l.setSpeed(speed);
	l.play();
}

Fn_ReSizeGroup(Group g, int TargetX, int TargetY, Float Speed, int TargetA){

        g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetSpeed(Speed);
        g.setTargetA(TargetA);
        g.gotoTarget();
}

Fn_ReSizeLayer(AnimatedLayer a, int TargetX, int TargetY, Float Speed, int TargetA){

        a.setTargetX(TargetX);
        a.setTargetY(TargetY);
        a.setTargetSpeed(Speed);
        a.setTargetA(TargetA);
        a.gotoTarget();
}
Fn_ChangeImage(){

}