#include "std.mi"

Function UpdateVis(Int Frame);


Global Group		grpMain;
Global Group		grpAniItem03;
Global Timer		VisTimer;
Global Double		Level, OneFrame;
Global Int		LastFrame;

Global AnimatedLayer	aniVu1;
Global AnimatedLayer	aniVu2;

Global Int		intVuState;

System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpAniItem03	= grpMain.findObject("Ani_Item01.Group");
	aniVu1		= grpAniItem03.findObject("Ani_Item05");
	aniVu2		= grpAniItem03.findObject("Ani_Item06");
	intVuState	= System.getPrivateInt("No6", "VuState03", 0);

	aniVu1.hide();
	aniVu2.hide();

	VisTimer = new Timer;
	VisTimer.setDelay(50);
	VisTimer.start();

	if(intVuState == 0) {
		aniVu1.Show();
		aniVu1.setSpeed(50);
		OneFrame = 255/(aniVu1.getLength());
	}
	else if(intVuState == 1) {
		aniVu2.Show();
		aniVu2.setSpeed(50);
		OneFrame = 255/(aniVu2.getLength());
	}

}

System.onScriptUnloading() {


	System.setPrivateInt("No6", "VuState03", intVuState);
	VisTimer.stop();
    	delete VisTimer;
}

aniVu1.onLeftButtonDblClk(int x, int y){

	intVuState ++;
	aniVu1.HIde();
	aniVu2.Show();
}
aniVu2.onLeftButtonDblClk(int x, int y){

	intVuState ++;
	if(intVuState >= 2) intVuState = 0;
	aniVu1.Show();
	aniVu2.Hide();
}

VisTimer.onTimer() {

	Level = ((System.getLeftVuMeter() + System.getRightVuMeter())/2);
	UpdateVis(Level/OneFrame);

}

UpdateVis(Int Frame){

	if(intVuState == 0) {
		aniVu1.setStartFrame(LastFrame);
		aniVu1.setEndFrame(Frame);
		aniVu1.play();
		LastFrame = Frame;
	}
	if(intVuState == 1) {
		aniVu2.setStartFrame(LastFrame);
		aniVu2.setEndFrame(Frame);
		aniVu2.play();
		LastFrame = Frame;
	}
}

