#include "std.mi"

Function Fn_StartAnim(AnimatedLayer l, int start, int end, int speed);
Function Fn_ReSizeGroup(Group g, int TargetX, int TargetY, Float Speed, int TargetA);

Global Group		grpMain;
Global Group		grpChara;
Global Group		grpSerif02;
Global AnimatedLayer	aniSerif02;
Global Layer		lyrChara02;
Global int 		intSerifNo;
Global int 		intSerifTime;
Global Timer		tmrSerifON;
Global Timer		tmrSerifOFF;

System.onScriptLoaded() {

	grpMain 	= getScriptGroup();
	grpChara	= grpMain.findObject("Chara02.Group");
	grpSerif02	= grpMain.findObject("Chara_Serif02.Group");
	aniSerif02	= grpSerif02.findObject("Chara02_Serif");
//	lyrChara02	= grpChara.findObject("Chara02_Image");

	tmrSerifOFF = new Timer;
	tmrSerifON = new Timer;

	intSerifTime	= System.random(4);

	if(intSerifTime == 0){
		tmrSerifON.setDelay(2000);
	}
	if(intSerifTime == 1){
		tmrSerifON.setDelay(70000);
	}
	if(intSerifTime == 2){
		tmrSerifON.setDelay(30000);
	}
	if(intSerifTime == 3){
		tmrSerifON.setDelay(110000);
	}

	tmrSerifON.start();
}

System.onScriptUnloading() {

	tmrSerifON.stop();
	delete tmrSerifON;

	tmrSerifOFF.stop();
	delete tmrSerifOFF;
}

tmrSerifON.onTimer() {

	tmrSerifON.stop();

	Fn_ReSizeGroup(grpChara, 100, 43, 0.1, 255);

	intSerifNo = System.random(12);

	if (intSerifNo == 0) Fn_StartAnim(aniSerif02, 1, 1, 0);
	else if (intSerifNo == 1)Fn_StartAnim(aniSerif02, 2, 2, 0);
	else if (intSerifNo == 2)Fn_StartAnim(aniSerif02, 3, 3, 0);
	else if (intSerifNo == 3)Fn_StartAnim(aniSerif02, 4, 4, 0);
        else if (intSerifNo == 4)Fn_StartAnim(aniSerif02, 5, 5, 0);
        else if (intSerifNo == 5)Fn_StartAnim(aniSerif02, 6, 6, 0);
        else if (intSerifNo == 6)Fn_StartAnim(aniSerif02, 7, 7, 0);
        else if (intSerifNo == 7)Fn_StartAnim(aniSerif02, 8, 8, 0);
        else if (intSerifNo == 8)Fn_StartAnim(aniSerif02, 9, 9, 0);
        else if (intSerifNo == 9)Fn_StartAnim(aniSerif02, 10, 10, 0);
        else if (intSerifNo == 10)Fn_StartAnim(aniSerif02, 11, 11, 0);
        else if (intSerifNo == 11)Fn_StartAnim(aniSerif02, 12, 12, 0);

	intSerifTime	= System.random(4);

	if(intSerifTime == 0){
		tmrSerifON.setDelay(9000);
	}
	if(intSerifTime == 1){
		tmrSerifON.setDelay(30000);
	}
	if(intSerifTime == 2){
		tmrSerifON.setDelay(60000);
	}
	if(intSerifTime == 3){
		tmrSerifON.setDelay(110000);
	}

	tmrSerifON.start();

	tmrSerifOFF.setDelay(4000);
	tmrSerifOFF.start();
}

tmrSerifOFF.onTimer() {

	tmrSerifOFF.stop();
	Fn_StartAnim(aniSerif02, 0, 0, 0);
	Fn_ReSizeGroup(grpChara, 100, 45, 0.1, 255);

}
Fn_StartAnim(AnimatedLayer l, int start, int end, int speed) {

	l.stop();
	l.setStartFrame(start);
	l.setEndFrame(end);
	l.setSpeed(speed);
	l.play();
}
Fn_ReSizeGroup(Group g, int TargetX, int TargetY, Float Speed, int TargetA){

        g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetSpeed(Speed);
        g.setTargetA(TargetA);
        g.gotoTarget();
}