#include "std.mi"

Function Fn_StartAnim(AnimatedLayer l, int start, int end, int speed);
Function Fn_ReSizeGroup(Group g, int TargetX, int TargetY, Float Speed, int TargetA);

Global Group		grpMain;
Global Group		grpChara;
Global Group		grpSerif04;
Global AnimatedLayer	aniSerif04;
Global Layer		lyrChara04;
Global int 		intSerifNo;
Global int 		intSerifTime;
Global Timer		tmrSerifON;
Global Timer		tmrSerifOFF;

System.onScriptLoaded() {

	grpMain 	= getScriptGroup();
	grpChara	= grpMain.findObject("Chara04.Group");
	grpSerif04	= grpMain.findObject("Chara_Serif04.Group");
	aniSerif04	= grpSerif04.findObject("Chara04_Serif");
//	lyrChara04	= grpChara.findObject("Chara04_Image");

	tmrSerifOFF = new Timer;
	tmrSerifON = new Timer;

	intSerifTime	= System.random(4);

	if(intSerifTime == 0){
		tmrSerifON.setDelay(7000);
	}
	if(intSerifTime == 1){
		tmrSerifON.setDelay(112000);
	}
	if(intSerifTime == 2){
		tmrSerifON.setDelay(50000);
	}
	if(intSerifTime == 3){
		tmrSerifON.setDelay(30000);
	}

	tmrSerifON.start();
}

System.onScriptUnloading() {

	tmrSerifON.stop();
	delete tmrSerifON;

	tmrSerifOFF.stop();
	delete tmrSerifOFF;
}

tmrSerifON.onTimer() {

	tmrSerifON.stop();

	Fn_ReSizeGroup(grpChara, 278, 47, 0.1, 255);

	intSerifNo = System.random(12);

	if (intSerifNo == 0) Fn_StartAnim(aniSerif04, 1, 1, 0);
	else if (intSerifNo == 1)Fn_StartAnim(aniSerif04, 2, 2, 0);
	else if (intSerifNo == 2)Fn_StartAnim(aniSerif04, 3, 3, 0);
	else if (intSerifNo == 3)Fn_StartAnim(aniSerif04, 4, 4, 0);
        else if (intSerifNo == 4)Fn_StartAnim(aniSerif04, 5, 5, 0);
        else if (intSerifNo == 5)Fn_StartAnim(aniSerif04, 6, 6, 0);
        else if (intSerifNo == 6)Fn_StartAnim(aniSerif04, 7, 7, 0);
        else if (intSerifNo == 7)Fn_StartAnim(aniSerif04, 8, 8, 0);
        else if (intSerifNo == 8)Fn_StartAnim(aniSerif04, 9, 9, 0);
        else if (intSerifNo == 9)Fn_StartAnim(aniSerif04, 10, 10, 0);
        else if (intSerifNo == 10)Fn_StartAnim(aniSerif04, 11, 11, 0);
        else if (intSerifNo == 11)Fn_StartAnim(aniSerif04, 12, 12, 0);

	intSerifTime	= System.random(4);

	if(intSerifTime == 0){
		tmrSerifON.setDelay(10000);
	}
	if(intSerifTime == 1){
		tmrSerifON.setDelay(70000);
	}
	if(intSerifTime == 2){
		tmrSerifON.setDelay(20000);
	}
	if(intSerifTime == 3){
		tmrSerifON.setDelay(112000);
	}

	tmrSerifON.start();


	tmrSerifOFF.setDelay(4000);
	tmrSerifOFF.start();
}

tmrSerifOFF.onTimer() {

	tmrSerifOFF.stop();
	Fn_StartAnim(aniSerif04, 0, 0, 0);
	Fn_ReSizeGroup(grpChara, 278, 49, 0.1, 255);

}
Fn_StartAnim(AnimatedLayer l, int start, int end, int speed) {

	l.stop();
	l.setStartFrame(start);
	l.setEndFrame(end);
	l.setSpeed(speed);
	l.play();
}
Fn_ReSizeGroup(Group g, int TargetX, int TargetY, Float Speed, int TargetA){

        g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetSpeed(Speed);
        g.setTargetA(TargetA);
        g.gotoTarget();
}