#include "std.mi"

Function Fn_StartAnim(AnimatedLayer l, int start, int end, int speed);

Global Group		grpMain;
Global Group		grpPLMLVDBtn;
Global Group		grpAlbmArt;
Global AnimatedLayer	anibtnAlbArt;
Global int 		intAlbArtState;

System.onScriptLoaded() {

	grpMain 		= getScriptGroup();
	grpPLMLVDBtn		= grpMain.findObject("PlMlVdButtons.Group");
	grpAlbmArt		= grpMain.findObject("AlbumArt.Group");
	anibtnAlbArt		= grpPLMLVDBtn.findObject("AlbumArt_button");
	intAlbArtState		= System.getPrivateInt("No6", "AlbArtState", 0);

	if(intAlbArtState == 0) grpAlbmArt.Show();
	if(intAlbArtState == 1) grpAlbmArt.Hide();

	Fn_StartAnim(anibtnAlbArt,0, 0, 0);
}

System.onScriptUnloading() {

	System.setPrivateInt("No6", "AlbArtState", intAlbArtState);
}

anibtnAlbArt.onEnterArea(){

	Fn_StartAnim(anibtnAlbArt, 1, 1, 0);
}
anibtnAlbArt.onLeftButtonDown(int x, int y) {

	Fn_StartAnim(anibtnAlbArt, 2, 2, 0);

}
anibtnAlbArt.onLeftButtonUp(int x, int y) {

	Fn_StartAnim(anibtnAlbArt, 1, 1, 0);

	intAlbArtState ++;
	if(intAlbArtState >=2) intAlbArtState = 0;

	if(intAlbArtState == 0) grpAlbmArt.Show();
	if(intAlbArtState == 1) grpAlbmArt.Hide();
}
anibtnAlbArt.onLeaveArea(){

	Fn_StartAnim(anibtnAlbArt, 0, 0, 0);
}

Fn_StartAnim(AnimatedLayer l, int start, int end, int speed){

	l.stop();
	l.setStartFrame(start);
	l.setEndFrame(end);
	l.setSpeed(speed);
	l.play();
}