#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);


Global Group	grpMain;
Global Group	grpItem01;
Global Group	grpItem02;
Global Group	grpItem03;
Global Group	grpItem04;
Global Layer	lyrDrugItem01;
Global Layer	lyrDrugItem02;
Global Layer	lyrDrugItem03;
Global Layer	lyrDrugItem04;
Global int	intItm01PosX;
Global int	intItm01PosY;
Global int	intItm02PosX;
Global int	intItm02PosY;
Global int	intItm03PosX;
Global int	intItm03PosY;
Global int	intItm04PosX;
Global int	intItm04PosY;
Global int	intObjH;
Global int	intObjW;
Global Boolean	blnDrg;


System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpItem01	= grpMain.getObject("Chara_Item01.Group");
	grpItem02	= grpMain.getObject("Chara_Item02.Group");
	grpItem03	= grpMain.getObject("Chara_Item03.Group");
	grpItem04	= grpMain.getObject("Chara_Item04.Group");
	lyrDrugItem01	= grpItem01.getObject("Chara_Item01_Dummy");
	lyrDrugItem02	= grpItem02.getObject("Chara_Item02_Dummy");
	lyrDrugItem03	= grpItem03.getObject("Chara_Item03_Dummy");
	lyrDrugItem04	= grpItem04.getObject("Chara_Item04_Dummy");
	intItm01PosX	= System.getPrivateInt("No6", "Item01PosX", 0);
	intItm01PosY	= System.getPrivateInt("No6", "Item01PosY", 0);
	intItm02PosX	= System.getPrivateInt("No6", "Item02PosX", 0);
	intItm02PosY	= System.getPrivateInt("No6", "Item02PosY", 0);
	intItm03PosX	= System.getPrivateInt("No6", "Item03PosX", 0);
	intItm03PosY	= System.getPrivateInt("No6", "Item03PosY", 0);
	intItm04PosX	= System.getPrivateInt("No6", "Item04PosX", 0);
	intItm04PosY	= System.getPrivateInt("No6", "Item04PosY", 0);
	intObjW		= grpItem01.getGuiW();
	intObjH		= grpItem01.getGuiH();

	fn_ReSizeGroup(grpItem01, intItm01PosX, intItm01PosY, intObjW, intObjH, 0.1, 0.1, 255);
	fn_ReSizeGroup(grpItem02, intItm02PosX, intItm02PosY, intObjW, intObjH, 0.1, 0.1, 255);
	fn_ReSizeGroup(grpItem03, intItm03PosX, intItm03PosY, intObjW, intObjH, 0.1, 0.1, 255);
	fn_ReSizeGroup(grpItem04, intItm04PosX, intItm04PosY, intObjW, intObjH, 0.1, 0.1, 255);
}

System.onScriptUnloading(){

	System.setPrivateInt("No6", "Item01PosX", intItm01PosX);
	System.setPrivateInt("No6", "Item01PosY", intItm01PosY);
	System.setPrivateInt("No6", "Item02PosX", intItm02PosX);
	System.setPrivateInt("No6", "Item02PosY", intItm02PosY);
	System.setPrivateInt("No6", "Item03PosX", intItm03PosX);
	System.setPrivateInt("No6", "Item03PosY", intItm03PosY);
	System.setPrivateInt("No6", "Item04PosX", intItm04PosX);
	System.setPrivateInt("No6", "Item04PosY", intItm04PosY);
}

lyrDrugItem01.onLeftButtonDown(int x, int y) {

	blnDrg = 1;

	intItm01PosX = grpItem01.getLeft() - x;
	intItm01PosY = grpItem01.getTop() - y;
}

lyrDrugItem01.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (lyrDrugItem01.getLeft() < 0) {
		grpItem01.setXmlParam("x", "0");
	} 
	else if (lyrDrugItem01.getLeft() + lyrDrugItem01.getWidth() > 465) {
		grpItem01.setXmlParam("x", integerToString(465 - lyrDrugItem01.getWidth()));
	}

	if (lyrDrugItem01.getTop() < 0) {
	  	grpItem01.setXmlParam("y", "0");
	} 
	else if (lyrDrugItem01.getTop() + lyrDrugItem01.getHeight() > 340) {
		grpItem01.setXmlParam("y", integerToString(340 - lyrDrugItem01.getHeight()));
	}

	intItm01PosX = grpItem01.getLeft();
	intItm01PosY = grpItem01.getTop();
}

lyrDrugItem01.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpItem01.setXmlParam("x", integerToString(x + intItm01PosX));
	grpItem01.setXmlParam("y", integerToString(y + intItm01PosY));
}

lyrDrugItem02.onLeftButtonDown(int x, int y) {

	blnDrg = 1;

	intItm02PosX = grpItem02.getLeft() - x;
	intItm02PosY = grpItem02.getTop() - y;
}

lyrDrugItem02.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (lyrDrugItem02.getLeft() < 0) {
		grpItem02.setXmlParam("x", "0");
	} 
	else if (lyrDrugItem02.getLeft() + lyrDrugItem02.getWidth() > 465) {
		grpItem02.setXmlParam("x", integerToString(465 - lyrDrugItem02.getWidth()));
	}

	if (lyrDrugItem02.getTop() < 0) {
	  	grpItem02.setXmlParam("y", "0");
	} 
	else if (lyrDrugItem02.getTop() + lyrDrugItem02.getHeight() > 340) {
		grpItem02.setXmlParam("y", integerToString(340 - lyrDrugItem02.getHeight()));
	}

	intItm02PosX = grpItem02.getLeft();
	intItm02PosY = grpItem02.getTop();
}

lyrDrugItem02.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpItem02.setXmlParam("x", integerToString(x + intItm02PosX));
	grpItem02.setXmlParam("y", integerToString(y + intItm02PosY));
}

lyrDrugItem03.onLeftButtonDown(int x, int y) {

	blnDrg = 1;

	intItm03PosX = grpItem03.getLeft() - x;
	intItm03PosY = grpItem03.getTop() - y;
}

lyrDrugItem03.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (lyrDrugItem03.getLeft() < 0) {
		grpItem03.setXmlParam("x", "0");
	} 
	else if (lyrDrugItem03.getLeft() + lyrDrugItem03.getWidth() > 465) {
		grpItem03.setXmlParam("x", integerToString(465 - lyrDrugItem03.getWidth()));
	}

	if (lyrDrugItem03.getTop() < 0) {
	  	grpItem03.setXmlParam("y", "0");
	} 
	else if (lyrDrugItem03.getTop() + lyrDrugItem03.getHeight() > 340) {
		grpItem03.setXmlParam("y", integerToString(340 - lyrDrugItem03.getHeight()));
	}

	intItm03PosX = grpItem03.getLeft();
	intItm03PosY = grpItem03.getTop();
}

lyrDrugItem03.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpItem03.setXmlParam("x", integerToString(x + intItm03PosX));
	grpItem03.setXmlParam("y", integerToString(y + intItm03PosY));
}
lyrDrugItem04.onLeftButtonDown(int x, int y) {

	blnDrg = 1;

	intItm04PosX = grpItem04.getLeft() - x;
	intItm04PosY = grpItem04.getTop() - y;
}

lyrDrugItem04.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (lyrDrugItem04.getLeft() < 0) {
		grpItem04.setXmlParam("x", "0");
	} 
	else if (lyrDrugItem04.getLeft() + lyrDrugItem04.getWidth() > 465) {
		grpItem04.setXmlParam("x", integerToString(465 - lyrDrugItem04.getWidth()));
	}

	if (lyrDrugItem04.getTop() < 0) {
	  	grpItem04.setXmlParam("y", "0");
	} 
	else if (lyrDrugItem04.getTop() + lyrDrugItem04.getHeight() > 340) {
		grpItem04.setXmlParam("y", integerToString(340 - lyrDrugItem04.getHeight()));
	}

	intItm04PosX = grpItem04.getLeft();
	intItm04PosY = grpItem04.getTop();
}

lyrDrugItem04.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpItem04.setXmlParam("x", integerToString(x + intItm04PosX));
	grpItem04.setXmlParam("y", integerToString(y + intItm04PosY));
}
fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}