#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);


Global Group	grpMain;
Global Group	grpWindow;
Global Layer	lyrDrugWindow;
Global int	intWPosX;
Global int	intWPosY;
Global int	intObjH;
Global int	intObjW;
Global Boolean	blnDrg;


System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpWindow	= grpMain.getObject("Song_Info.Group");
	lyrDrugWindow	= grpWindow.getObject("Window_dummy");
	intWPosX	= System.getPrivateInt("No6", "WPosX", 0);
	intWPosY	= System.getPrivateInt("No6", "WPosY", 0);
	intObjW		= grpWindow.getGuiW();
	intObjH		= grpWindow.getGuiH();

	fn_ReSizeGroup(grpWindow, intWPosX, intWPosY, intObjW, intObjH, 0.1, 0.1, 255);
//	fn_ReSizeGroup(grpWindow, 0, 0, 336, 68, 0.1, 0.1, 255);
}

System.onScriptUnloading(){

	System.setPrivateInt("No6", "WPosX", intWPosX);
	System.setPrivateInt("No6", "WPosY", intWPosY);
}

lyrDrugWindow.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intWPosX = grpWindow.getLeft() - x;
	intWPosY = grpWindow.getTop() - y;
}

lyrDrugWindow.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (lyrDrugWindow.getLeft() < 0) {
	  grpWindow.setXmlParam("x", "0");
	} else if (lyrDrugWindow.getLeft() + lyrDrugWindow.getWidth() > 465) {
	  grpWindow.setXmlParam("x", integerToString(465 - lyrDrugWindow.getWidth()));
	}

	if (lyrDrugWindow.getTop() < 0) {
	  grpWindow.setXmlParam("y", "0");
	} else if (lyrDrugWindow.getTop() + lyrDrugWindow.getHeight() > 340) {
	  grpWindow.setXmlParam("y", integerToString(340 - lyrDrugWindow.getHeight()));
	}

	intWPosX = grpWindow.getLeft();
	intWPosY = grpWindow.getTop();
}

lyrDrugWindow.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpWindow.setXmlParam("x", integerToString(x + intWPosX));
	grpWindow.setXmlParam("y", integerToString(y + intWPosy));
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}