#include "std.mi"

Function Fn_StartAnim(AnimatedLayer l, int start, int end, int speed);
Function Fn_ReSizeGroup(Group g, int TargetX, int TargetY, Float Speed, int TargetA);

Global Group		grpMain;
Global Group		grpChara;
Global Group		grpSerif01;
Global AnimatedLayer	aniSerif01;
Global Layer		lyrChara01;
Global int 		intSerifNo;
Global int 		intSerifTime;
Global Timer		tmrSerifON;
Global Timer		tmrSerifOFF;

System.onScriptLoaded() {

	grpMain 	= getScriptGroup();
	grpChara	= grpMain.findObject("Chara01.Group");
	grpSerif01	= grpMain.findObject("Chara_Serif01.Group");
	aniSerif01	= grpSerif01.findObject("Chara01_Serif");

	tmrSerifOFF = new Timer;
	tmrSerifON = new Timer;

	intSerifTime	= System.random(4);

	if(intSerifTime == 0){
		tmrSerifON.setDelay(10000);
	}
	if(intSerifTime == 1){
		tmrSerifON.setDelay(60000);
	}
	if(intSerifTime == 2){
		tmrSerifON.setDelay(20000);
	}
	if(intSerifTime == 3){
		tmrSerifON.setDelay(50000);
	}

	tmrSerifON.start();

}

System.onScriptUnloading() {

	tmrSerifON.stop();
	delete tmrSerifON;

	tmrSerifOFF.stop();
	delete tmrSerifOFF;
}

tmrSerifON.onTimer() {

	tmrSerifON.stop();

	Fn_ReSizeGroup(grpChara, 0, 45, 0.1, 255);

	intSerifNo = System.random(12);

	if (intSerifNo == 0) Fn_StartAnim(aniSerif01, 1, 1, 0);
	else if (intSerifNo == 1)Fn_StartAnim(aniSerif01, 2, 2, 0);
	else if (intSerifNo == 2)Fn_StartAnim(aniSerif01, 3, 3, 0);
	else if (intSerifNo == 3)Fn_StartAnim(aniSerif01, 4, 4, 0);
        else if (intSerifNo == 4)Fn_StartAnim(aniSerif01, 5, 5, 0);
        else if (intSerifNo == 5)Fn_StartAnim(aniSerif01, 6, 6, 0);
        else if (intSerifNo == 6)Fn_StartAnim(aniSerif01, 7, 7, 0);
        else if (intSerifNo == 7)Fn_StartAnim(aniSerif01, 8, 8, 0);
        else if (intSerifNo == 8)Fn_StartAnim(aniSerif01, 9, 9, 0);
        else if (intSerifNo == 9)Fn_StartAnim(aniSerif01, 10, 10, 0);
        else if (intSerifNo == 10)Fn_StartAnim(aniSerif01, 11, 11, 0);
        else if (intSerifNo == 11)Fn_StartAnim(aniSerif01, 12, 12, 0);

	intSerifTime	= System.random(4);

	if(intSerifTime == 0){
		tmrSerifON.setDelay(40000);
	}
	if(intSerifTime == 1){
		tmrSerifON.setDelay(10000);
	}
	if(intSerifTime == 2){
		tmrSerifON.setDelay(104000);
	}
	if(intSerifTime == 3){
		tmrSerifON.setDelay(80000);
	}

	tmrSerifON.start();

	tmrSerifOFF.setDelay(4000);
	tmrSerifOFF.start();
}

tmrSerifOFF.onTimer() {

	tmrSerifOFF.stop();
	Fn_StartAnim(aniSerif01, 0, 0, 0);
	Fn_ReSizeGroup(grpChara, 0, 47, 0.1, 255);

}
Fn_StartAnim(AnimatedLayer l, int start, int end, int speed) {

	l.stop();
	l.setStartFrame(start);
	l.setEndFrame(end);
	l.setSpeed(speed);
	l.play();
}
Fn_ReSizeGroup(Group g, int TargetX, int TargetY, Float Speed, int TargetA){

        g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetSpeed(Speed);
        g.setTargetA(TargetA);
        g.gotoTarget();
}