#include "std.mi"

Function Fn_StartAnim(AnimatedLayer l, int start, int end, int speed);
Function Fn_ReSizeGroup(Group g, int TargetX, int TargetY, Float Speed, int TargetA);

Global Group		grpMain;
Global Group		grpChara;
Global Group		grpSerif03;
Global AnimatedLayer	aniSerif03;
Global Layer		lyrChara03;
Global int 		intSerifNo;
Global int 		intSerifTime;
Global Timer		tmrSerifON;
Global Timer		tmrSerifOFF;

System.onScriptLoaded() {

	grpMain 	= getScriptGroup();
	grpChara	= grpMain.findObject("Chara03.Group");
	grpSerif03	= grpMain.findObject("Chara_Serif03.Group");
	aniSerif03	= grpSerif03.findObject("Chara03_Serif");
//	lyrChara03	= grpChara.findObject("Chara03_Image");

	tmrSerifOFF = new Timer;
	tmrSerifON = new Timer;

	intSerifTime	= System.random(4);

	if(intSerifTime == 0){
		tmrSerifON.setDelay(3000);
	}
	if(intSerifTime == 1){
		tmrSerifON.setDelay(100000);
	}
	if(intSerifTime == 2){
		tmrSerifON.setDelay(60000);
	}
	if(intSerifTime == 3){
		tmrSerifON.setDelay(90000);
	}

	tmrSerifON.start();
}

System.onScriptUnloading() {

	tmrSerifON.stop();
	delete tmrSerifON;

	tmrSerifOFF.stop();
	delete tmrSerifOFF;
}

tmrSerifON.onTimer() {

	tmrSerifON.stop();

	Fn_ReSizeGroup(grpChara, 195, 48, 0.1, 255);

	intSerifNo = System.random(12);

	if (intSerifNo == 0) Fn_StartAnim(aniSerif03, 1, 1, 0);
	else if (intSerifNo == 1)Fn_StartAnim(aniSerif03, 2, 2, 0);
	else if (intSerifNo == 2)Fn_StartAnim(aniSerif03, 3, 3, 0);
	else if (intSerifNo == 3)Fn_StartAnim(aniSerif03, 4, 4, 0);
        else if (intSerifNo == 4)Fn_StartAnim(aniSerif03, 5, 5, 0);
        else if (intSerifNo == 5)Fn_StartAnim(aniSerif03, 6, 6, 0);
        else if (intSerifNo == 6)Fn_StartAnim(aniSerif03, 7, 7, 0);
        else if (intSerifNo == 7)Fn_StartAnim(aniSerif03, 8, 8, 0);
        else if (intSerifNo == 8)Fn_StartAnim(aniSerif03, 9, 9, 0);
        else if (intSerifNo == 9)Fn_StartAnim(aniSerif03, 10, 10, 0);
        else if (intSerifNo == 10)Fn_StartAnim(aniSerif03, 11, 11, 0);
        else if (intSerifNo == 11)Fn_StartAnim(aniSerif03, 12, 12, 0);

	intSerifTime	= System.random(4);

	if(intSerifTime == 0){
		tmrSerifON.setDelay(4000);
	}
	if(intSerifTime == 1){
		tmrSerifON.setDelay(60000);
	}
	if(intSerifTime == 2){
		tmrSerifON.setDelay(115000);
	}
	if(intSerifTime == 3){
		tmrSerifON.setDelay(50000);
	}

	tmrSerifON.start();

	tmrSerifOFF.setDelay(4000);
	tmrSerifOFF.start();
}

tmrSerifOFF.onTimer() {

	tmrSerifOFF.stop();
	Fn_StartAnim(aniSerif03, 0, 0, 0);
	Fn_ReSizeGroup(grpChara, 195, 50, 0.1, 255);

}
Fn_StartAnim(AnimatedLayer l, int start, int end, int speed) {

	l.stop();
	l.setStartFrame(start);
	l.setEndFrame(end);
	l.setSpeed(speed);
	l.play();
}
Fn_ReSizeGroup(Group g, int TargetX, int TargetY, Float Speed, int TargetA){

        g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetSpeed(Speed);
        g.setTargetA(TargetA);
        g.gotoTarget();
}