#include "std.mi"

Function Fn_setVolumeAnim(int volValue);
Function Fn_updateVolume(int x, int y);

Global Group		grpMain;
Global Group		grpVolume;
Global Group		grpSongInfo;
Global Layer   lyrVolume;
Global Map     mapVolMap;
Global Map     mapVolMap2;
Global Timer   tmrSongTickerTimer;
Global Boolean blnVolumeChanging;
Global int     intVolChangSet;
Global Boolean blnUpFlg;
Global Timer   tmrVolChange;
Global TEXT             txtVoltxt;

System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpSongInfo	= grpMain.findObject("Song_Info.Group");
	grpVolume	= grpSongInfo.findObject("Volume.Group");
	lyrVolume	= grpVolume.getObject("volume");
	txtVoltxt	= grpSongInfo.findObject("SongTime");

    tmrSongTickerTimer = new Timer;
    tmrSongTickerTimer.setDelay(750);
    tmrVolChange = new Timer;
    tmrVolChange.setDelay(1000);

    mapVolMap = new Map;
    mapVolMap.loadMap("Volumemap");
    mapVolMap2 = new Map;
    mapVolMap2.loadMap("Volumemap2");

    fn_setVolumeAnim(System.getVolume());
}

System.onVolumeChanged(int newVol) {
        fn_setVolumeAnim(newVol);
        tmrSongTickerTimer.start();
        int p = (newVol * 100) / 255;
        txtVoltxt.setAlternateText("Vol: " + System.integerToString(p)+"%");
}

tmrVolChange.onTimer() {

    tmrVolChange.stop();

    if(intVolChangSet != 0){
        blnUpFlg = 1;

        Float v = getVolume();
        v = (v / 255 * 100) + (1 * intVolChangSet);
        if(v > 100) v = 100;
        if(v < 0) v = 0;
        v *= 2.55;
      
        setVolume(v);

        tmrVolChange.setDelay(100);
        tmrVolChange.start();
    }
}

lyrVolume.onLeftButtonDown(int x, int y) {
        if (mapVolMap.inRegion(x - lyrVolume.getLeft(), y - lyrVolume.getTop())) {
                blnVolumeChanging = 1;
                fn_updateVolume(x, y);
        }
}

lyrVolume.onLeftButtonUp(int x, int y) {
        if (blnVolumeChanging) {
                blnVolumeChanging = 0;
                fn_updateVolume(x, y);
        }
}

lyrVolume.onMouseMove(int x, int y) {
        if (mapVolMap2.inRegion(x - lyrVolume.getLeft(), y - lyrVolume.getTop())) {
                if (blnVolumeChanging) {
                  fn_updateVolume(x, y);
                }
        }
}



Fn_setVolumeAnim(int Value) {
        Region r = new Region;
        r.loadFromMap(mapVolMap2, Value, 1);
        lyrVolume.setRegion(r);
        delete r;
}

Fn_updateVolume(int x, int y) {
          int newValue = mapVolMap2.getValue(x - lyrVolume.getLeft(), y - lyrVolume.getTop());
          System.setVolume(newValue);
}