#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);

Global Group		grpMain;
Global Group		grpItem01;
Global AnimatedLayer	aniItem01;
Global AnimatedLayer	aniItem02;
Global int		intPosX;
Global int		intPosY;
Global int		intObjH;
Global int		intObjW;
Global Boolean		blnDrg;

System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpItem01	= grpMain.getObject("Ani_Item01.Group");
	aniItem01	= grpItem01.getObject("Ani_Item01");
	aniItem02	= grpItem01.getObject("Ani_Item02");

	intPosX		= System.getPrivateInt("Amatukaze", "I01PosX", 0);
	intPosY		= System.getPrivateInt("Amatukaze", "I01PosY", 0);
	intObjW		= grpItem01.getGuiW();
	intObjH		= grpItem01.getGuiH();

	fn_ReSizeGroup(grpItem01, intPosX, intPosY, intObjW, intObjH, 1.0, 1.0, 255);
}

System.onScriptUnloading(){

	System.setPrivateInt("Amatukaze", "I01PosX", intPosX);
	System.setPrivateInt("Amatukaze", "I01PosY", intPosY);
}

AniItem01.onLeftButtonDown(int x, int y) {

	blnDrg = 1;

	intPosX = grpItem01.getLeft() - x;
	intPosY = grpItem01.getTop() - y;
}
AniItem01.onLeftButtonUp(int x, int y) {


	blnDrg = 0;

	if (grpItem01.getLeft() < 0) {
		grpItem01.setXmlParam("x", "0");
	} 
	else if (grpItem01.getLeft() + grpItem01.getWidth() > 355) {
		grpItem01.setXmlParam("x", integerToString(355 - grpItem01.getWidth()));
	}

	if (grpItem01.getTop() < 0) {
	  	grpItem01.setXmlParam("y", "0");
	} 
	else if (grpItem01.getTop() + grpItem01.getHeight() > 485) {
		grpItem01.setXmlParam("y", integerToString(485 - grpItem01.getHeight()));
	}

	intPosX = grpItem01.getLeft();
	intPosY = grpItem01.getTop();
}
AniItem01.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpItem01.setXmlParam("x", integerToString(x + intPosX));
	grpItem01.setXmlParam("y", integerToString(y + intPosy));
}


AniItem02.onLeftButtonDown(int x, int y) {

	blnDrg = 1;

	intPosX = grpItem01.getLeft() - x;
	intPosY = grpItem01.getTop() - y;
}
AniItem02.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (grpItem01.getLeft() < 0) {
		grpItem01.setXmlParam("x", "0");
	} 
	else if (grpItem01.getLeft() + grpItem01.getWidth() > 355) {
		grpItem01.setXmlParam("x", integerToString(355 - grpItem01.getWidth()));
	}

	if (grpItem01.getTop() < 0) {
	  	grpItem01.setXmlParam("y", "0");
	} 
	else if (grpItem01.getTop() + grpItem01.getHeight() > 485) {
		grpItem01.setXmlParam("y", integerToString(485 - grpItem01.getHeight()));
	}

	intPosX = grpItem01.getLeft();
	intPosY = grpItem01.getTop();
}
AniItem02.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpItem01.setXmlParam("x", integerToString(x + intPosX));
	grpItem01.setXmlParam("y", integerToString(y + intPosy));
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}
