#include "std.mi"

Function UpdateVis(Int Frame);


Global Group		grpMain;
Global Group		grpVuMater;
Global Timer		VisTimer;
Global Double		Level,OneFrame;
Global Int		LastFrame;
Global AnimatedLayer	aniVu;
Global AnimatedLayer	aniVu2;
Global Int		intVuState; // ( 0; Ani_Item01, 1; Ani_Item02)

System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpVuMater	= grpMain.findObject("Ani_Item01.Group");
	aniVu		= grpVuMater.findObject("Ani_Item01");
	aniVu2		= grpVuMater.findObject("Ani_Item02");

	intVuState	= System.getPrivateInt("LoveLive", "VuState", 0);

	aniVu.hide();
	aniVu2.hide();

	VisTimer = new Timer;
	VisTimer.setDelay(50);
	VisTimer.start();

	if(intVuState == 0) {
		aniVu.Show();
		aniVu.setSpeed(50);
		OneFrame = 255/(aniVu.getLength());
	}
	else if(intVuState == 1) {
		aniVu2.Show();
		aniVu2.setSpeed(50);
		OneFrame = 255/(aniVu2.getLength());
	}
}

System.onScriptUnloading() {


	System.setPrivateInt("LoveLive", "VuState", intVuState);
	VisTimer.stop();
    	delete VisTimer;
}

aniVu.onLeftButtonDblClk(int x, int y){

	intVuState ++;
	aniVu.HIde();
	aniVu2.Show();
}
aniVu2.onLeftButtonDblClk(int x, int y){

	intVuState ++;
	if(intVuState >= 2) intVuState = 0;
	aniVu.Show();
	aniVu2.Hide();
}

VisTimer.onTimer() {

	Level = ((System.getLeftVuMeter() + System.getRightVuMeter())/2);
	UpdateVis(Level/OneFrame);
}

UpdateVis(Int Frame){

	if(intVuState == 0) {
		aniVu.setStartFrame(LastFrame);
		aniVu.setEndFrame(Frame);
		aniVu.play();
		LastFrame = Frame;
	}
	else if(intVuState == 1) {
		aniVu2.setStartFrame(LastFrame);
		aniVu2.setEndFrame(Frame);
		aniVu2.play();
		LastFrame = Frame;
	}

}

