#include "std.mi"

Function UpdateVis(Int Frame);


Global Group		grpMain;
Global Group		grpPlay;
Global Timer		VisTimer;
Global Double		Level,OneFrame;
Global Int		LastFrame;
Global AnimatedLayer	aniPause;
Global Button		btnPause;
Global Int		intState;

System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpPlay		= grpMain.findObject("Play.Group");
	aniPause	= grpPlay.findObject("Ani_Pause");
	btnPause	= grpPlay.findObject("Pause");

	VisTimer = new Timer;
	VisTimer.setDelay(50);
	VisTimer.start();

	aniPause.setSpeed(50);
	OneFrame = 255/(aniPause.getLength());

	//vCԊmF STATUS_PAUSED (-1), STATUS_STOPPED (0), STATUS_PLAYING (1)
	if(getStatus() == 1) {
       		aniPause.Show();
	}
	else if(getStatus() == 0) {
		aniPause.hide();
	}
	else if(getStatus() == -1) {
		aniPause.hide();
	}
}

System.onScriptUnloading() {
	
	VisTimer.stop();
    	delete VisTimer;
}


VisTimer.onTimer() {

	Level = ((System.getLeftVuMeter() + System.getRightVuMeter())/2);
	UpdateVis(Level/OneFrame);

	if(intState == 0){
		if(Level < 26)	btnPause.SetAlpha(255);
		else if(Level > 26)	btnPause.SetAlpha(0);
	}
}

btnPause.onEnterArea() {

	intState = 1;
	aniPause.hide();
	btnPause.SetAlpha(255);

}

btnPause.onLeaveArea() {

	intState = 0;
	btnPause.SetAlpha(0);

	//vCԊmF STATUS_PAUSED (-1), STATUS_STOPPED (0), STATUS_PLAYING (1)
	if(getStatus() == 1) {
       		aniPause.Show();
	}
	else if(getStatus() == 0) {
		aniPause.hide();
	}
	else if(getStatus() == -1) {
		aniPause.hide();
	}
}
system.onplay() {

       	aniPause.Show();
}
system.onstop() {

	aniPause.hide();
}

system.onpause() {

	aniPause.hide();
}

system.onResume() {

       	aniPause.Show();
}

UpdateVis(Int Frame){

	aniPause.setStartFrame(LastFrame);
     	aniPause.setEndFrame(Frame);
     	aniPause.play();
     	LastFrame = Frame;
}

