#include "std.mi"

Function Fn_StartAnim(AnimatedLayer l, int start, int end, int speed);

Global Group		grpMain;
Global Group		grpRepeatButton;
Global Group		grpVolume;
Global AnimatedLayer	aniVolBg;
Global Button		btnVolup;
Global Button		btnVolDown;

System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpRepeatButton	= grpMain.getObject("RepShuButtons.Group");
	grpVolume	= grpRepeatButton.getObject("Volume_Button.Group");
	aniVolBg	= grpVolume.getObject("AniVolumeBG");
	btnVolup	= grpVolume.getObject("VolumeUP");
	btnVolDown	= grpVolume.getObject("VolumeDown");
}

btnVolup.onEnterArea(){

	Fn_StartAnim(aniVolBg, 1, 1, 0);
}
btnVolup.onLeaveArea(){

	Fn_StartAnim(aniVolBg, 0, 0, 0);
}
btnVolup.onLeftButtonDown(int x, int y) {

	Fn_StartAnim(aniVolBg, 2, 2, 0);
}
btnVolup.onLeftButtonUp(int x, int y) {

	Fn_StartAnim(aniVolBg, 1, 1, 0);
}

btnVolDown.onEnterArea(){

	Fn_StartAnim(aniVolBg, 1, 1, 0);
}
btnVolDown.onLeaveArea(){

	Fn_StartAnim(aniVolBg, 0, 0, 0);
}
btnVolDown.onLeftButtonDown(int x, int y) {

	Fn_StartAnim(aniVolBg, 2, 2, 0);
}
btnVolDown.onLeftButtonUp(int x, int y) {

	Fn_StartAnim(aniVolBg, 1, 1, 0);
}

Fn_StartAnim(AnimatedLayer l, int start, int end, int speed){

	l.stop();
	l.setStartFrame(start);
	l.setEndFrame(end);
	l.setSpeed(speed);
	l.play();
}
