#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);

Global Group	grpMain;
Global Group	grpPlay;
Global Group	grpEject;
Global Group	grpNext;
Global Group	grpPrev;
Global Group	grpStop;
Global Group	grpCompo;
Global Group	grpRepeat;

Global Button	btnDragPlay;
Global Button	btnDragEject;
Global Button	btnDragNext;
Global Button	btnDragPrev;
Global Button	btnDragStop;
Global Button	btnDragCompo;
Global Button	btnDragRepeat;

Global int	intPPosX;
Global int	intPPosY;
Global int	intEPosX;
Global int	intEPosY;
Global int	intNPosX;
Global int	intNPosY;
Global int	intPrPosX;
Global int	intPrPosY;
Global int	intSPosX;
Global int	intSPosY;
Global int	intCPosX;
Global int	intCPosY;
Global int	intRPosX;
Global int	intRPosY;

Global int	intPObjH;
Global int	intPObjW;
Global int	intEObjH;
Global int	intEObjW;
Global int	intNObjH;
Global int	intNObjW;
Global int	intPrObjH;
Global int	intPrObjW;
Global int	intSObjH;
Global int	intSObjW;
Global int	intCObjH;
Global int	intCObjW;
Global int	intRObjH;
Global int	intRObjW;

Global Boolean	blnDrg;


System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpPlay		= grpMain.getObject("Play.Group");
	grpEject	= grpMain.getObject("Eject.Group");
	grpNext		= grpMain.getObject("Next.Group");
	grpPrev		= grpMain.getObject("Previous.Group");
	grpStop		= grpMain.getObject("Stop.Group");
	grpCompo	= grpMain.getObject("PlMlVdButtons.Group");
	grpRepeat	= grpMain.getObject("RepShuButtons.Group");

	btnDragPlay	= grpPlay.getObject("Drag_Button_Play");
	btnDragEject	= grpEject.getObject("Drag_Button_Eject");
	btnDragNext	= grpNext.getObject("Drag_Button_Next");
	btnDragPrev	= grpPrev.getObject("Drag_Button_Prev");
	btnDragStop	= grpStop.getObject("Drag_Button_Stop");
	btnDragCompo	= grpCompo.getObject("Drag_Button_Compo");
	btnDragRepeat	= grpRepeat.getObject("Drag_Button_RepShu");

	intPPosX	= System.getPrivateInt("LoveLive", "PPosX", 0);
	intPPosY	= System.getPrivateInt("LoveLive", "PPosY", 0);
	intEPosX	= System.getPrivateInt("LoveLive", "EPosX", 0);
	intEPosY	= System.getPrivateInt("LoveLive", "EPosY", 0);
	intNPosX	= System.getPrivateInt("LoveLive", "NPosX", 0);
	intNPosY	= System.getPrivateInt("LoveLive", "NPosY", 0);
	intPrPosX	= System.getPrivateInt("LoveLive", "PrPosX", 0);
	intPrPosY	= System.getPrivateInt("LoveLive", "PrPosY", 0);
	intSPosX	= System.getPrivateInt("LoveLive", "SPosX", 0);
	intSPosY	= System.getPrivateInt("LoveLive", "SPosY", 0);
	intCPosX	= System.getPrivateInt("LoveLive", "CPosX", 0);
	intCPosY	= System.getPrivateInt("LoveLive", "CPosY", 0);
	intRPosX	= System.getPrivateInt("LoveLive", "RPosX", 0);
	intRPosY	= System.getPrivateInt("LoveLive", "RPosY", 0);

	intPObjW	= grpPlay.getGuiW();
	intPObjH	= grpPlay.getGuiH();
	intEObjW	= grpEject.getGuiW();
	intEObjH	= grpEject.getGuiH();
	intNObjW	= grpNext.getGuiW();
	intNObjH	= grpNext.getGuiH();
	intPrObjW	= grpPrev.getGuiW();
	intPrObjH	= grpPrev.getGuiH();
	intSObjW	= grpStop.getGuiW();
	intSObjH	= grpStop.getGuiH();
	intCObjW	= grpCompo.getGuiW();
	intCObjH	= grpCompo.getGuiH();
	intRObjW	= grpRepeat.getGuiW();
	intRObjH	= grpRepeat.getGuiH();

	fn_ReSizeGroup(grpPlay, intPPosX, intPPosY, intPObjW, intPObjH, 1.0, 1.0, 255);
	fn_ReSizeGroup(grpEject, intEPosX, intEPosY, intEObjW, intEObjH, 1.4, 1.4, 255);
	fn_ReSizeGroup(grpNext, intNPosX, intNPosY, intNObjW, intNObjH, 1.1, 1.1, 255);
	fn_ReSizeGroup(grpPrev, intPrPosX, intPrPosY, intPrObjW, intPrObjH, 1.3, 1.3, 255);
	fn_ReSizeGroup(grpStop, intSPosX, intSPosY, intSObjW, intSObjH, 1.2, 1.2, 255);
	fn_ReSizeGroup(grpCompo, intCPosX, intCPosY, intCObjW, intCObjH, 1.0, 1.0, 255);
	fn_ReSizeGroup(grpRepeat, intRPosX, intRPosY, intRObjW, intRObjH, 1.2, 1.2, 255);
}

System.onScriptUnloading(){

	System.setPrivateInt("LoveLive", "PPosX", intPPosX);
	System.setPrivateInt("LoveLive", "PPosY", intPPosY);
	System.setPrivateInt("LoveLive", "EPosX", intEPosX);
	System.setPrivateInt("LoveLive", "EPosY", intEPosY);
	System.setPrivateInt("LoveLive", "NPosX", intNPosX);
	System.setPrivateInt("LoveLive", "NPosY", intNPosY);
	System.setPrivateInt("LoveLive", "PrPosX", intPrPosX);
	System.setPrivateInt("LoveLive", "PrPosY", intPrPosY);
	System.setPrivateInt("LoveLive", "SPosX", intSPosX);
	System.setPrivateInt("LoveLive", "SPosY", intSPosY);
	System.setPrivateInt("LoveLive", "CPosX", intCPosX);
	System.setPrivateInt("LoveLive", "CPosY", intCPosY);
	System.setPrivateInt("LoveLive", "RPosX", intRPosX);
	System.setPrivateInt("LoveLive", "RPosY", intRPosY);
}

btnDragPlay.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intPPosX = grpPlay.getLeft() - x;
	intPPosY = grpPlay.getTop() - y;
}
btnDragPlay.onLeftButtonUp(int x, int y) {


	blnDrg = 0;

	if (grpPlay.getLeft() < 0) {
		grpPlay.setXmlParam("x", "0");
	} 
	else if (grpPlay.getLeft() + grpPlay.getWidth() > 350) {
		grpPlay.setXmlParam("x", integerToString(350 - grpPlay.getWidth()));
	}

	if (grpPlay.getTop() < 0) {
	  	grpPlay.setXmlParam("y", "0");
	} 
	else if (grpPlay.getTop() + grpPlay.getHeight() > 470) {
		grpPlay.setXmlParam("y", integerToString(470 - grpPlay.getHeight()));
	}

	intPPosX = grpPlay.getLeft();
	intPPosY = grpPlay.getTop();
}

btnDragPlay.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpPlay.setXmlParam("x", integerToString(x + intPPosX));
	grpPlay.setXmlParam("y", integerToString(y + intPPosY));
}

btnDragEject.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intEPosX = grpEject.getLeft() - x;
	intEPosY = grpEject.getTop() - y;
}
btnDragEject.onLeftButtonUp(int x, int y) {


	blnDrg = 0;

	if (grpEject.getLeft() < 0) {
		grpEject.setXmlParam("x", "0");
	} 
	else if (grpEject.getLeft() + grpEject.getWidth() > 350) {
		grpEject.setXmlParam("x", integerToString(350 - grpEject.getWidth()));
	}

	if (btnDragEject.getTop() < 0) {
	  	grpEject.setXmlParam("y", "0");
	} 
	else if (grpEject.getTop() + grpEject.getHeight() > 470) {
		grpEject.setXmlParam("y", integerToString(470 - grpEject.getHeight()));
	}

	intEPosX = grpEject.getLeft();
	intEPosY = grpEject.getTop();
}
btnDragEject.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpEject.setXmlParam("x", integerToString(x + intEPosX));
	grpEject.setXmlParam("y", integerToString(y + intEPosY));
}

btnDragNext.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intNPosX = grpNext.getLeft() - x;
	intNPosY = grpNext.getTop() - y;
}
btnDragNext.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (grpNext.getLeft() < 0) {
		grpNext.setXmlParam("x", "0");
	} 
	else if (grpNext.getLeft() + grpNext.getWidth() > 350) {
		grpNext.setXmlParam("x", integerToString(350 - grpNext.getWidth()));
	}

	if (grpNext.getTop() < 0) {
	  	grpNext.setXmlParam("y", "0");
	} 
	else if (grpNext.getTop() + grpNext.getHeight() > 470) {
		grpNext.setXmlParam("y", integerToString(470 - grpNext.getHeight()));
	}

	intNPosX = grpNext.getLeft();
	intNPosY = grpNext.getTop();
}
btnDragNext.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpNext.setXmlParam("x", integerToString(x + intNPosX));
	grpNext.setXmlParam("y", integerToString(y + intNPosY));
}

btnDragPrev.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intPrPosX = grpPrev.getLeft() - x;
	intPrPosY = grpPrev.getTop() - y;
}
btnDragPrev.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (grpPrev.getLeft() < 0) {
		grpPrev.setXmlParam("x", "0");
	} 
	else if (grpPrev.getLeft() + grpPrev.getWidth() > 350) {
		grpPrev.setXmlParam("x", integerToString(350 - grpPrev.getWidth()));
	}

	if (grpPrev.getTop() < 0) {
	  	grpPrev.setXmlParam("y", "0");
	} 
	else if (grpPrev.getTop() + grpPrev.getHeight() > 470) {
		grpPrev.setXmlParam("y", integerToString(470 - grpPrev.getHeight()));
	}

	intPrPosX = grpPrev.getLeft();
	intPrPosY = grpPrev.getTop();
}
btnDragPrev.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpPrev.setXmlParam("x", integerToString(x + intPrPosX));
	grpPrev.setXmlParam("y", integerToString(y + intPrPosY));
}

btnDragStop.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intSPosX = grpStop.getLeft() - x;
	intSPosY = grpStop.getTop() - y;
}
btnDragStop.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (grpStop.getLeft() < 0) {
		grpStop.setXmlParam("x", "0");
	} 
	else if (grpStop.getLeft() + grpStop.getWidth() > 350) {
		grpStop.setXmlParam("x", integerToString(350 - grpStop.getWidth()));
	}

	if (grpStop.getTop() < 0) {
	  	grpStop.setXmlParam("y", "0");
	} 
	else if (grpStop.getTop() + grpStop.getHeight() > 470) {
		grpStop.setXmlParam("y", integerToString(470 - grpStop.getHeight()));
	}

	intSPosX = grpStop.getLeft();
	intSPosY = grpStop.getTop();
}
btnDragStop.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpStop.setXmlParam("x", integerToString(x + intSPosX));
	grpStop.setXmlParam("y", integerToString(y + intSPosY));
}
btnDragCompo.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intCPosX = grpCompo.getLeft() - x;
	intCPosY = grpCompo.getTop() - y;
}
btnDragCompo.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (grpCompo.getLeft() < 0) {
		grpCompo.setXmlParam("x", "0");
	} 
	else if (grpCompo.getLeft() + grpCompo.getWidth() > 350) {
		grpCompo.setXmlParam("x", integerToString(350 - grpCompo.getWidth()));
	}

	if (grpCompo.getTop() < 0) {
	  	grpCompo.setXmlParam("y", "0");
	} 
	else if (grpCompo.getTop() + grpCompo.getHeight() > 470) {
		grpCompo.setXmlParam("y", integerToString(470 - grpCompo.getHeight()));
	}

	intCPosX = grpCompo.getLeft();
	intCPosY = grpCompo.getTop();
}
btnDragCompo.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpCompo.setXmlParam("x", integerToString(x + intCPosX));
	grpCompo.setXmlParam("y", integerToString(y + intCPosY));
}
btnDragRepeat.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intRPosX = grpRepeat.getLeft() - x;
	intRPosY = grpRepeat.getTop() - y;
}
btnDragRepeat.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (grpRepeat.getLeft() < 0) {
		grpRepeat.setXmlParam("x", "0");
	} 
	else if (grpRepeat.getLeft() + grpRepeat.getWidth() > 350) {
		grpRepeat.setXmlParam("x", integerToString(350 - grpRepeat.getWidth()));
	}

	if (grpRepeat.getTop() < 0) {
	  	grpRepeat.setXmlParam("y", "0");
	} 
	else if (grpRepeat.getTop() + grpRepeat.getHeight() > 470) {
		grpRepeat.setXmlParam("y", integerToString(470 - grpRepeat.getHeight()));
	}

	intRPosX = grpRepeat.getLeft();
	intRPosY = grpRepeat.getTop();
}
btnDragRepeat.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpRepeat.setXmlParam("x", integerToString(x + intRPosX));
	grpRepeat.setXmlParam("y", integerToString(y + intRPosY));
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}