#include "std.mi"

Function Fn_StartAnim(AnimatedLayer l, int start, int end, int speed);

Global Group		grpMain;
Global Group		grpRepBtn;
Global Group		grpAnibtnAlbmArt;
Global Group		grpAlbmArt;
Global AnimatedLayer	anibtnAlbArt;
Global int 		intAlbArtState;
Global int 		intAlbArtState2;

System.onScriptLoaded() {

	grpMain 		= getScriptGroup();
	grpRepBtn		= grpMain.findObject("RepShuButtons.Group");
	grpAnibtnAlbmArt	= grpRepBtn.findObject("AlbumArt_button.Group");
	anibtnAlbArt		= grpAnibtnAlbmArt.findObject("AlbumArt_button");
	grpAlbmArt		= grpMain.findObject("AlbumArt.Group");
	intAlbArtState		= System.getPrivateInt("500AA", "AlbArtState", 0);
	intAlbArtState2		= System.getPrivateInt("500AA", "AlbArtState2", 0);

	if(intAlbArtState == 1) grpAlbmArt.Show();
	if(intAlbArtState == 0) grpAlbmArt.Hide();
	if(intAlbArtState2 == 1) Fn_StartAnim(anibtnAlbArt, 0, 0, 0);
	if(intAlbArtState2 == 0) Fn_StartAnim(anibtnAlbArt, 3, 3, 0);
}

System.onScriptUnloading() {

	System.setPrivateInt("500AA", "AlbArtState", intAlbArtState);
	System.setPrivateInt("500AA", "AlbArtState2", intAlbArtState2);
}

anibtnAlbArt.onEnterArea(){

	if(intAlbArtState2 == 1) Fn_StartAnim(anibtnAlbArt, 1, 1, 0);
	if(intAlbArtState2 == 0) Fn_StartAnim(anibtnAlbArt, 4, 4, 0);
}
anibtnAlbArt.onLeftButtonDown(int x, int y) {

	if(intAlbArtState2 == 1) Fn_StartAnim(anibtnAlbArt, 2, 2, 0);
	if(intAlbArtState2 == 0) Fn_StartAnim(anibtnAlbArt, 5, 5, 0);

}
anibtnAlbArt.onLeftButtonUp(int x, int y) {

	Fn_StartAnim(anibtnAlbArt, 1, 1, 0);

	intAlbArtState ++;
	if(intAlbArtState >=2) intAlbArtState = 0;

	intAlbArtState2 ++;
	if(intAlbArtState2 >=2) intAlbArtState2 = 0;

	if(intAlbArtState == 1) grpAlbmArt.Show();
	if(intAlbArtState == 0) grpAlbmArt.Hide();

	if(intAlbArtState2 == 1) Fn_StartAnim(anibtnAlbArt, 1, 1, 0);
	if(intAlbArtState2 == 0) Fn_StartAnim(anibtnAlbArt, 4, 4, 0);

}
anibtnAlbArt.onLeaveArea(){

	if(intAlbArtState2 == 1) Fn_StartAnim(anibtnAlbArt, 0, 0, 0);
	if(intAlbArtState2 == 0) Fn_StartAnim(anibtnAlbArt, 3, 3, 0);
}

Fn_StartAnim(AnimatedLayer l, int start, int end, int speed){

	l.stop();
	l.setStartFrame(start);
	l.setEndFrame(end);
	l.setSpeed(speed);
	l.play();
}