#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);


Global Group	grpMain;
Global Group	grpAlbumA;
Global Layer	lryDrugAlbumA;
Global int	intPosX;
Global int	intPosY;
Global int	intObjH;
Global int	intObjW;
Global Boolean	blnDrg;


System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpAlbumA	= grpMain.getObject("AlbumArt.Group");
	lryDrugAlbumA	= grpAlbumA.getObject("AlbumArt_BG_dummy");
	intPosX		= System.getPrivateInt("500", "PosX", 0);
	intPosY		= System.getPrivateInt("500", "PosY", 0);
	intObjW		= grpAlbumA.getGuiW();
	intObjH		= grpAlbumA.getGuiH();

	fn_ReSizeGroup(grpAlbumA, intPosX, intPosY, intObjW, intObjH, 1.2, 1.2, 255);
}

System.onScriptUnloading(){

	System.setPrivateInt("500", "PosX", intPosX);
	System.setPrivateInt("500", "PosY", intPosY);
}

lryDrugAlbumA.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intPosX = grpAlbumA.getLeft() - x;
	intPosY = grpAlbumA.getTop() - y;
}

lryDrugAlbumA.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (lryDrugAlbumA.getLeft() < 0) {
		grpAlbumA.setXmlParam("x", "0");
	} 
	else if (lryDrugAlbumA.getLeft() + lryDrugAlbumA.getWidth() > 390) {
		grpAlbumA.setXmlParam("x", integerToString(390 - lryDrugAlbumA.getWidth()));
	}

	if (lryDrugAlbumA.getTop() < 0) {
	  	grpAlbumA.setXmlParam("y", "0");
	} 
	else if (lryDrugAlbumA.getTop() + lryDrugAlbumA.getHeight() > 420) {
		grpAlbumA.setXmlParam("y", integerToString(420 - lryDrugAlbumA.getHeight()));
	}

	intPosX = grpAlbumA.getLeft();
	intPosY = grpAlbumA.getTop();
}
lryDrugAlbumA.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpAlbumA.setXmlParam("x", integerToString(x + intPosX));
	grpAlbumA.setXmlParam("y", integerToString(y + intPosy));
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}