#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);


Global Group	grpMain;
Global Group	grpWindow;
Global Layer	lyrDrugWindow;
Global int	intWPosX;
Global int	intWPosY;
Global int	intObjH;
Global int	intObjW;
Global Boolean	blnDrg;


System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpWindow	= grpMain.getObject("Song_Info.Group");
	lyrDrugWindow	= grpWindow.getObject("Window_dummy");
	intWPosX	= System.getPrivateInt("500", "WPosX", 0);
	intWPosY	= System.getPrivateInt("500", "WPosY", 0);
	intObjW		= grpWindow.getGuiW();
	intObjH		= grpWindow.getGuiH();

	fn_ReSizeGroup(grpWindow, intWPosX, intWPosY, intObjW, intObjH, 1.0, 1.0, 255);
}

System.onScriptUnloading(){

	System.setPrivateInt("500", "WPosX", intWPosX);
	System.setPrivateInt("500", "WPosY", intWPosY);
}

lyrDrugWindow.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intWPosX = grpWindow.getLeft() - x;
	intWPosY = grpWindow.getTop() - y;
}

lyrDrugWindow.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (grpWindow.getLeft() < 0) {
		grpWindow.setXmlParam("x", "0");
	} 
	else if (grpWindow.getLeft() + grpWindow.getWidth() > 390) {
		grpWindow.setXmlParam("x", integerToString(390 - grpWindow.getWidth()));
	}

	if (grpWindow.getTop() < 0) {
	  	grpWindow.setXmlParam("y", "0");
	} 
	else if (grpWindow.getTop() + grpWindow.getHeight() > 420) {
		grpWindow.setXmlParam("y", integerToString(420 - grpWindow.getHeight()));
	}

	intWPosX = grpWindow.getLeft();
	intWPosY = grpWindow.getTop();
}

lyrDrugWindow.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpWindow.setXmlParam("x", integerToString(x + intWPosX));
	grpWindow.setXmlParam("y", integerToString(y + intWPosy));
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}