#include "std.mi"

Function UpdateVis(Int Frame);


Global Group		grpMain;
Global Group		grpVuMater;
Global Timer		VisTimer;
Global Double		Level,OneFrame;
Global Int		LastFrame;
Global AnimatedLayer	aniVu1;
Global AnimatedLayer	aniVu2;
Global AnimatedLayer	aniVu3;

System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpVuMater	= grpMain.findObject("AniName.Group");
	aniVu1		= grpVuMater.findObject("AniName1");
	aniVu2		= grpVuMater.findObject("AniName2");
	aniVu3		= grpVuMater.findObject("AniName3");

	VisTimer = new Timer;
	VisTimer.setDelay(50);
	VisTimer.start();

	aniVu1.setSpeed(50);
	aniVu2.setSpeed(50);
	aniVu3.setSpeed(50);

	OneFrame = 255/(aniVu1.getLength());
	OneFrame = 255/(aniVu2.getLength());
	OneFrame = 255/(aniVu3.getLength());
}

System.onScriptUnloading() {
	
	VisTimer.stop();
    	delete VisTimer;
}


VisTimer.onTimer() {

	Level = ((System.getLeftVuMeter() + System.getRightVuMeter())/2);
	UpdateVis(Level/OneFrame);
}

UpdateVis(Int Frame){

	aniVu1.setStartFrame(LastFrame);
     	aniVu1.setEndFrame(Frame);
     	aniVu1.play();
     	LastFrame = Frame;

	aniVu2.setStartFrame(LastFrame);
     	aniVu2.setEndFrame(Frame);
     	aniVu2.play();
     	LastFrame = Frame;

	aniVu3.setStartFrame(LastFrame);
     	aniVu3.setEndFrame(Frame);
     	aniVu3.play();
     	LastFrame = Frame;
}

