#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);


Global Group	grpMain;
Global Group	grpAlbumA;
Global Button	btnDrugAlbumA;
Global int	intPosX;
Global int	intPosY;
Global int	intObjH;
Global int	intObjW;
Global Boolean	blnDrg;


System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpAlbumA	= grpMain.getObject("AlbumArt.Group");
	btnDrugAlbumA	= grpAlbumA.getObject("DrugAlbumABtn");
	intPosX		= System.getPrivateInt("eriezeA", "PosX", 0);
	intPosY		= System.getPrivateInt("eriezeA", "PosY", 0);
	intObjW		= grpAlbumA.getGuiW();
	intObjH		= grpAlbumA.getGuiH();

	fn_ReSizeGroup(grpAlbumA, intPosX, intPosY, intObjW, intObjH, 0.1, 0.1, 0);
}

System.onScriptUnloading(){

	System.setPrivateInt("eriezeA", "PosX", intPosX);
	System.setPrivateInt("eriezeA", "PosY", intPosY);
}

btnDrugAlbumA.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intPosX = grpAlbumA.getLeft() - x;
	intPosY = grpAlbumA.getTop() - y;
}

btnDrugAlbumA.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (grpAlbumA.getLeft() < 0) {
		grpAlbumA.setXmlParam("x", "0");
	} 
	else if (grpAlbumA.getLeft() + grpAlbumA.getWidth() > 400) {
		grpAlbumA.setXmlParam("x", integerToString(400 - grpAlbumA.getWidth()));
	}

	if (grpAlbumA.getTop() < 0) {
	  	grpAlbumA.setXmlParam("y", "0");
	} 
	else if (grpAlbumA.getTop() + grpAlbumA.getHeight() > 450) {
		grpAlbumA.setXmlParam("y", integerToString(450 - grpAlbumA.getHeight()));
	}

	intPosX = grpAlbumA.getLeft();
	intPosY = grpAlbumA.getTop();
}

btnDrugAlbumA.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpAlbumA.setXmlParam("x", integerToString(x + intPosX));
	grpAlbumA.setXmlParam("y", integerToString(y + intPosy));
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}