#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);


Global Group	grpMain;
Global Group	grpPlayButton;
Global Button	btnDrugPlay;
Global int	intPosX;
Global int	intPosY;
Global int	intObjH;
Global int	intObjW;
Global Boolean	blnDrg;


System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpPlayButton	= grpMain.getObject("PlayButton.Group");
	btnDrugPlay	= grpPlayButton.getObject("DrugPlayBtn");
	intPosX		= System.getPrivateInt("eriezeP", "PosX", 0);
	intPosY		= System.getPrivateInt("eriezeP", "PosY", 0);
	intObjW		= grpPlayButton.getGuiW();
	intObjH		= grpPlayButton.getGuiH();

	fn_ReSizeGroup(grpPlayButton, intPosX, intPosY, intObjW, intObjH, 0.1, 0.1, 0);
}

System.onScriptUnloading(){

	System.setPrivateInt("eriezeP", "PosX", intPosX);
	System.setPrivateInt("eriezeP", "PosY", intPosY);
}

btnDrugPlay.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intPosX = grpPlayButton.getLeft() - x;
	intPosY = grpPlayButton.getTop() - y;
}

btnDrugPlay.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (grpPlayButton.getLeft() < 0) {
		grpPlayButton.setXmlParam("x", "0");
	} 
	else if (grpPlayButton.getLeft() + grpPlayButton.getWidth() > 400) {
		grpPlayButton.setXmlParam("x", integerToString(400 - grpPlayButton.getWidth()));
	}

	if (grpPlayButton.getTop() < 0) {
	  	grpPlayButton.setXmlParam("y", "0");
	} 
	else if (grpPlayButton.getTop() + grpPlayButton.getHeight() > 450) {
		grpPlayButton.setXmlParam("y", integerToString(450 - grpPlayButton.getHeight()));
	}

	intPosX = grpPlayButton.getLeft();
	intPosY = grpPlayButton.getTop();
}

btnDrugPlay.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpPlayButton.setXmlParam("x", integerToString(x + intPosX));
	grpPlayButton.setXmlParam("y", integerToString(y + intPosy));
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}