#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);


Global Group	grpMain;
Global Group	grpSongWindow;
Global layer	lyrDrugSongInfo;
Global int	intPosX;
Global int	intPosY;
Global int	intObjH;
Global int	intObjW;
Global Boolean	blnDrg;


System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpSongWindow	= grpMain.getObject("SongWindow.Group");
	lyrDrugSongInfo	= grpSongWindow.getObject("DrugSongInfo");
	intPosX		= System.getPrivateInt("erieze", "PosX", 0);
	intPosY		= System.getPrivateInt("erieze", "PosY", 0);
	intObjW		= grpSongWindow.getGuiW();
	intObjH		= grpSongWindow.getGuiH();

	fn_ReSizeGroup(grpSongWindow, intPosX, intPosY, intObjW, intObjH, 0.1, 0.1, 0);
}

System.onScriptUnloading(){

	System.setPrivateInt("erieze", "PosX", intPosX);
	System.setPrivateInt("erieze", "PosY", intPosY);
}

lyrDrugSongInfo.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intPosX = grpSongWindow.getLeft() - x;
	intPosY = grpSongWindow.getTop() - y;
}

lyrDrugSongInfo.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (grpSongWindow.getLeft() < 0) {
		grpSongWindow.setXmlParam("x", "0");
	} 
	else if (grpSongWindow.getLeft() + grpSongWindow.getWidth() > 400) {
		grpSongWindow.setXmlParam("x", integerToString(400 - grpSongWindow.getWidth()));
	}

	if (grpSongWindow.getTop() < 0) {
	  	grpSongWindow.setXmlParam("y", "0");
	} 
	else if (grpSongWindow.getTop() + grpSongWindow.getHeight() > 450) {
		grpSongWindow.setXmlParam("y", integerToString(450 - grpSongWindow.getHeight()));
	}

	intPosX = grpSongWindow.getLeft();
	intPosY = grpSongWindow.getTop();
}

lyrDrugSongInfo.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpSongWindow.setXmlParam("x", integerToString(x + intPosX));
	grpSongWindow.setXmlParam("y", integerToString(y + intPosy));
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}