#include "std.mi"

Function Fn_CharaChange();
Function Fn_FadeLayer(Layer l,int TargetA, Float Speed);
Function Fn_AnimatedLayer(AnimatedLayer A,int TargetA, Float Speed);

Global Group		grpMain;
Global Group		grpBtn;
Global Group		grpChr;
Global Group		grpAlbA;
Global Group		grpVu;
Global Group		grpSogIfo;
Global Group		grpSogIfoChr;
Global Button		btnChange;
Global Layer		lyrChr1;
Global Layer		lyrChr2;
Global Layer		lyrChr3;
Global Layer		lyrAlbA1;
Global Layer		lyrAlbA2;
Global Layer		lyrAlbA3;
Global Layer		lyrSogIfoChr1;
Global Layer		lyrSogIfoChr2;
Global Layer		lyrSogIfoChr3;
Global AnimatedLayer	aniVu1;
Global AnimatedLayer	aniVu2;
Global AnimatedLayer	aniVu3;
Global int		intCharaNmber;	//( 0, 1, 2)
Global Timer		tmrAlpha;

System.onScriptLoaded() {

	grpMain 	= getScriptGroup();
	grpChr		= grpMain.findObject("Chara.Group");
	grpBtn		= grpMain.findObject("RepeatButton.Group");
	grpAlbA		= grpMain.findObject("AlbumArt.Group");
	grpVu		= grpMain.findObject("AniName.Group");
	grpSogIfo	= grpMain.findObject("SongWindow.Group");
	grpSogIfoChr	= grpSogIfo.findObject("SongInfo_Chara.Group");
	btnChange	= grpBtn.findObject("BtnChange_Chara");
	lyrChr1		= grpChr.findObject("Chara1_Image");
	lyrChr2		= grpChr.findObject("Chara2_Image");
	lyrChr3		= grpChr.findObject("Chara3_Image");
	lyrAlbA1	= grpAlbA.findObject("AlbArt1");
	lyrAlbA2	= grpAlbA.findObject("AlbArt3");
	lyrAlbA3	= grpAlbA.findObject("AlbArt4");
	aniVu1		= grpVu.findObject("AniName1");
	aniVu2		= grpVu.findObject("AniName2");
	aniVu3		= grpVu.findObject("AniName3");
	lyrSogIfoChr1	= grpSogIfoChr.findObject("SongInfo_Chara1");
	lyrSogIfoChr2	= grpSogIfoChr.findObject("SongInfo_Chara2");
	lyrSogIfoChr3	= grpSogIfoChr.findObject("SongInfo_Chara3");

	intCharaNmber	= System.getPrivateInt("erieze", "CharaNmber", 0);

	tmrAlpha = new Timer;
	Fn_CharaChange();

}

System.onScriptUnloading() {

	System.setPrivateInt("erieze", "CharaNmber", intCharaNmber);

	tmrAlpha.Stop();
	delete tmrAlpha;
}

btnChange.onLeftButtonUp(int x,int y) {

	intCharaNmber++;
	if(intCharaNmber >= 3) intCharaNmber = 0;

	Fn_CharaChange();
}

Fn_CharaChange() {

	if(intCharaNmber == 0){

		Fn_FadeLayer(lyrChr1, 255, 1);
		Fn_FadeLayer(lyrChr2, 0, 1);
		Fn_FadeLayer(lyrChr3, 0, 1);

		Fn_FadeLayer(lyrAlbA1, 255, 1);
		Fn_FadeLayer(lyrAlbA2, 0, 1);
		Fn_FadeLayer(lyrAlbA3, 0, 1);

		Fn_AnimatedLayer(aniVu1, 255, 1);
		Fn_AnimatedLayer(aniVu2, 0, 1);
		Fn_AnimatedLayer(aniVu3, 0, 1);

		Fn_FadeLayer(lyrSogIfoChr1, 255, 1);
		Fn_FadeLayer(lyrSogIfoChr2, 0, 1);
		Fn_FadeLayer(lyrSogIfoChr3, 0, 1);

	}

	else if(intCharaNmber == 1){

		Fn_FadeLayer(lyrChr1, 0, 1);
		Fn_FadeLayer(lyrChr2, 255, 1);
		Fn_FadeLayer(lyrChr3, 0, 1);

		Fn_FadeLayer(lyrAlbA1, 0, 1);
		Fn_FadeLayer(lyrAlbA2, 255, 1);
		Fn_FadeLayer(lyrAlbA3, 0, 1);

		Fn_AnimatedLayer(aniVu1, 0, 1);
		Fn_AnimatedLayer(aniVu2, 255, 1);
		Fn_AnimatedLayer(aniVu3, 0, 1);

		Fn_FadeLayer(lyrSogIfoChr1, 0, 1);
		Fn_FadeLayer(lyrSogIfoChr2, 255, 1);
		Fn_FadeLayer(lyrSogIfoChr3, 0, 1);
	}

	else if(intCharaNmber == 2){

		Fn_FadeLayer(lyrChr1, 0, 1);
		Fn_FadeLayer(lyrChr2, 0, 1);
		Fn_FadeLayer(lyrChr3, 255, 1);

		Fn_FadeLayer(lyrAlbA1, 0, 1);
		Fn_FadeLayer(lyrAlbA2, 0, 1);
		Fn_FadeLayer(lyrAlbA3, 255, 1);

		Fn_AnimatedLayer(aniVu1, 0, 1);
		Fn_AnimatedLayer(aniVu2, 0, 1);
		Fn_AnimatedLayer(aniVu3, 255, 1);

		Fn_FadeLayer(lyrSogIfoChr1, 0, 1);
		Fn_FadeLayer(lyrSogIfoChr2, 0, 1);
		Fn_FadeLayer(lyrSogIfoChr3, 255, 1);

	}

        tmrAlpha.setDelay(1000);
        tmrAlpha.start();
}

tmrAlpha.onTimer() {

        tmrAlpha.Stop();

	Fn_FadeLayer(lyrSogIfoChr1, 0, 1);
	Fn_FadeLayer(lyrSogIfoChr2, 0, 1);
	Fn_FadeLayer(lyrSogIfoChr3, 0, 1);
}

Fn_FadeLayer(Layer l,int TargetA, Float Speed) {

	l.setTargetA(TargetA);
	l.setTargetSpeed(Speed);
	l.gotoTarget();
}

Fn_AnimatedLayer(AnimatedLayer A,int TargetA, Float Speed) {

	A.setTargetA(TargetA);
	A.setTargetSpeed(Speed);
	A.gotoTarget();
}

