#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);


Global Group	grpMain;
Global Group	grpCompoButton;
Global Button	btnDrugCompo;
Global int	intPosX;
Global int	intPosY;
Global int	intObjH;
Global int	intObjW;
Global Boolean	blnDrg;


System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpCompoButton	= grpMain.getObject("CompoButton.Group");
	btnDrugCompo	= grpCompoButton.getObject("DrugCompoBtn");
	intPosX		= System.getPrivateInt("eriezeC", "PosX", 0);
	intPosY		= System.getPrivateInt("eriezeC", "PosY", 0);
	intObjW		= grpCompoButton.getGuiW();
	intObjH		= grpCompoButton.getGuiH();

	fn_ReSizeGroup(grpCompoButton, intPosX, intPosY, intObjW, intObjH, 0.1, 0.1, 0);
}

System.onScriptUnloading(){

	System.setPrivateInt("eriezeC", "PosX", intPosX);
	System.setPrivateInt("eriezeC", "PosY", intPosY);
}

btnDrugCompo.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intPosX = grpCompoButton.getLeft() - x;
	intPosY = grpCompoButton.getTop() - y;
}

btnDrugCompo.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (grpCompoButton.getLeft() < 0) {
		grpCompoButton.setXmlParam("x", "0");
	} 
	else if (grpCompoButton.getLeft() + grpCompoButton.getWidth() > 400) {
		grpCompoButton.setXmlParam("x", integerToString(400 - grpCompoButton.getWidth()));
	}

	if (grpCompoButton.getTop() < 0) {
	  	grpCompoButton.setXmlParam("y", "0");
	} 
	else if (grpCompoButton.getTop() + grpCompoButton.getHeight() > 450) {
		grpCompoButton.setXmlParam("y", integerToString(450 - grpCompoButton.getHeight()));
	}

	intPosX = grpCompoButton.getLeft();
	intPosY = grpCompoButton.getTop();
}

btnDrugCompo.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpCompoButton.setXmlParam("x", integerToString(x + intPosX));
	grpCompoButton.setXmlParam("y", integerToString(y + intPosy));
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}