#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA);


Global Group	grpMain;
Global Group	grpRepButton;
Global Button	btnDrugRep;
Global int	intPosX;
Global int	intPosY;
Global int	intObjH;
Global int	intObjW;
Global Boolean	blnDrg;


System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpRepButton	= grpMain.getObject("RepeatButton.Group");
	btnDrugRep	= grpRepButton.getObject("DrugCompoBtn2");
	intPosX		= System.getPrivateInt("eriezeR", "PosX", 0);
	intPosY		= System.getPrivateInt("eriezeR", "PosY", 0);
	intObjW		= grpRepButton.getGuiW();
	intObjH		= grpRepButton.getGuiH();

	fn_ReSizeGroup(grpRepButton, intPosX, intPosY, intObjW, intObjH, 0.1, 0.1, 0);
}

System.onScriptUnloading(){

	System.setPrivateInt("eriezeR", "PosX", intPosX);
	System.setPrivateInt("eriezeR", "PosY", intPosY);
}

btnDrugRep.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intPosX = grpRepButton.getLeft() - x;
	intPosY = grpRepButton.getTop() - y;
}

btnDrugRep.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (grpRepButton.getLeft() < 0) {
		grpRepButton.setXmlParam("x", "0");
	} 
	else if (grpRepButton.getLeft() + grpRepButton.getWidth() > 400) {
		grpRepButton.setXmlParam("x", integerToString(400 - grpRepButton.getWidth()));
	}

	if (grpRepButton.getTop() < 0) {
	  	grpRepButton.setXmlParam("y", "0");
	} 
	else if (grpRepButton.getTop() + grpRepButton.getHeight() > 450) {
		grpRepButton.setXmlParam("y", integerToString(450 - grpRepButton.getHeight()));
	}

	intPosX = grpRepButton.getLeft();
	intPosY = grpRepButton.getTop();
}

btnDrugRep.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpRepButton.setXmlParam("x", integerToString(x + intPosX));
	grpRepButton.setXmlParam("y", integerToString(y + intPosy));
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH, int TargetA){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.setTargetA(TargetA);
        g.gotoTarget();
}