#include "std.mi"

#define ROTATION_LAYER_VAR Seconds
#include "rotationlayer.m"

Global Group		grpMain;
Global GuiObject	guiGroup;
Global Layer		lyrRotaName;
Global Timer            tmrValue;
Global Int              intValue;
Global Timer            tmrAction;


System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	guiGroup	= grpMain.findObject("aisha_Ring1.Group");
	lyrRotaName	= grpMain.findObject("Ring1");

	tmrValue   = new Timer;
	tmrAction  = new Timer;

	_SecondsInit(grpMain, "Ring1");	//"]C["

	//vCԊmF STATUS_PAUSED (-1), STATUS_STOPPED (0), STATUS_PLAYING (1)
	if(getStatus() == 1){

		tmrValue.setDelay(50);
		tmrValue.start();
		lyrRotaName.setTargetA(255);
		lyrRotaName.gotoTarget();
	}
	else if(getStatus() == -1){

		tmrAction.setDelay(50);
		tmrAction.start();
	}
	else if(getStatus() == 0){

		intValue = 0;
		lyrRotaName.setTargetA(0);
		lyrRotaName.gotoTarget();
	}
}

System.onScriptUnloading() {

	tmrValue.Stop();
	delete tmrValue;

	tmrAction.Stop();
	delete tmrAction;
}

System.onPlay() {

	tmrValue.start();
	tmrAction.Stop();

	lyrRotaName.setTargetA(255);
	lyrRotaName.gotoTarget();
}

System.onpause() {

	tmrValue.stop();

	tmrAction.setDelay(50);
	tmrAction.start();
}

System.onResume() {

	tmrValue.start();
	tmrAction.Stop();

	lyrRotaName.setTargetA(255);
	lyrRotaName.gotoTarget();
}

System.onstop() {

	tmrValue.stop();
	tmrAction.Stop();
	intValue = 0;

	lyrRotaName.setTargetA(0);
	lyrRotaName.gotoTarget();
}

tmrAction.onTimer() {

	tmrAction.Stop();

	int intAction;

	if(intAction == 0) {

		lyrRotaName.setTargetA(0);
		lyrRotaName.setTargetSpeed(1.0);
		lyrRotaName.gotoTarget();
		intAction = 1;
	}
	else if(intAction == 1) {
		
		lyrRotaName.setTargetA(255);
		lyrRotaName.setTargetSpeed(1.0);
		lyrRotaName.gotoTarget();
		intAction = 0;
	}

	tmrAction.setDelay(800);
	tmrAction.start();
}

tmrValue.onTimer() {

	int oldintValue = intValue;

	if(intValue <= 5000){
		intValue --;
		intValue = oldintValue - 2;
		tmrValue.setDelay(50);
		tmrValue.start();
		_SecondsRotateDegree(intValue);
	}
	else if(intValue >= 5000){
		intValue = 0;
		tmrValue.setDelay(50);
		tmrValue.start();
		_SecondsRotateDegree(intValue);
	}
}

