#include "std.mi"

Function UpdateVis(Int Frame);


Global Group		grpMain;
Global Group		grpAniItem01;
Global Timer		VisTimer;
Global Double		Level, OneFrame;
Global Int		LastFrame;

Global AnimatedLayer	aniVu1;

System.onScriptLoaded() {

	grpMain		= getScriptGroup();
	grpAniItem01	= grpMain.findObject("Ani_Item01.Group");
	aniVu1		= grpAniItem01.findObject("Ani_Item01");

	VisTimer = new Timer;
	VisTimer.setDelay(50);
	VisTimer.start();

	aniVu1.setSpeed(50);
	OneFrame = 255/(aniVu1.getLength());
}

System.onScriptUnloading() {

	VisTimer.stop();
    	delete VisTimer;
}

VisTimer.onTimer() {

	Level = (System.getLeftVuMeter());
	UpdateVis(Level/OneFrame);

}

UpdateVis(Int Frame){

	aniVu1.setStartFrame(LastFrame);
	aniVu1.setEndFrame(Frame);
	aniVu1.play();
	LastFrame = Frame;
}

