#include "std.mi"

Function Fn_StartAnim(AnimatedLayer l, int start, int end, int speed);
Function Fn_ReSizeGroup(Group g, int TargetX, int TargetY, Float Speed, int TargetA);
Function Fn_ChangeImage();

Global Group		grpMain;
Global Group 		grpRepShu;
Global Group 		grpRepeat;
Global AnimatedLayer 	aniRepeat;
Global ToggleButton	tglRepeat;
Global Int		intRepeatState;     //0:Repeat OFFA1:Repeat ONA-1:Repeat TRACK
Global Int		intRepeatImage;
Global Int		intPosX;
Global Int		intPosY;

System.onScriptLoaded() {

	grpMain 	= getScriptGroup();
	grpRepShu	= grpMain.getObject("PlMlVdButtons.Group");
	grpRepeat	= grpRepShu.getObject("RepeatButtons.Group");
	tglRepeat 	= grpRepeat.findObject("Repeat");
	aniRepeat 	= grpRepeat.findObject("AniRepeat");

	intRepeatState = stringtointeger(tglRepeat.getXmlParam("cfgval"));

	if (intRepeatState == 0)       Fn_StartAnim(aniRepeat, 0, 0, 0);
	else if (intRepeatState == 1)  Fn_StartAnim(aniRepeat, 6, 6, 0);
	else if (intRepeatState == -1) Fn_StartAnim(aniRepeat, 3, 3, 0);
}

tglRepeat.onToggle(boolean on) {

	intRepeatState = stringtointeger(tglRepeat.getXmlParam("cfgval"));

	if (intRepeatState == 0)       Fn_StartAnim(aniRepeat, 0, 0, 0);
	else if (intRepeatState == 1)  Fn_StartAnim(aniRepeat, 6, 6, 0);
	else if (intRepeatState == -1) Fn_StartAnim(aniRepeat, 3, 3, 0);
}

tglRepeat.onLeftButtonDown(int x, int y) {

	Fn_ReSizeGroup(grpRepeat, 1, 18, 0.1, 255);
}
tglRepeat.onLeftButtonUp(int x, int y) {

	intRepeatImage = 0;

	Fn_ChangeImage();
	Fn_ReSizeGroup(grpRepeat, 0, 17, 0.1, 255);
}
tglRepeat.onEnterArea(){

	intRepeatImage = 0;
	Fn_ChangeImage();
}
tglRepeat.onLeaveArea(){

	intRepeatImage = 1;
	Fn_ChangeImage();
}
Fn_StartAnim(AnimatedLayer l, int start, int end, int speed){

	l.stop();
	l.setStartFrame(start);
	l.setEndFrame(end);
	l.setSpeed(speed);
	l.play();
}

Fn_ReSizeGroup(Group g, int TargetX, int TargetY, Float Speed, int TargetA){

        g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetSpeed(Speed);
        g.setTargetA(TargetA);
        g.gotoTarget();
}
Fn_ChangeImage(){

	intRepeatState = stringtointeger(tglRepeat.getXmlParam("cfgval"));

	if (intRepeatImage == 0){
		if (intRepeatState == 0)       Fn_StartAnim(aniRepeat, 1, 1, 0);
		else if (intRepeatState == 1)  Fn_StartAnim(aniRepeat, 7, 7, 0);
		else if (intRepeatState == -1) Fn_StartAnim(aniRepeat, 4, 4, 0);
	} else {
		if (intRepeatState == 0)       Fn_StartAnim(aniRepeat, 0, 0, 0);
		else if (intRepeatState == 1)  Fn_StartAnim(aniRepeat, 6, 6, 0);
		else if (intRepeatState == -1) Fn_StartAnim(aniRepeat, 3, 3, 0);
	}
}